/* KorbBroker.hh */
/* Created by Enomoto Sanshiro on 13 February 2000. */
/* Last updated by Enomoto Sanshiro on 29 July 2001. */


#ifndef __KorbBroker_hh__
#define __KorbBroker_hh__


#include <string>
#include <vector>
#include "MushProcess.hh"
#include "MushNetworkSocket.hh"
#include "KorbNetworkHub.hh"
#include "KorbNetworkAdapter.hh"
#include "KorbNetworkPacket.hh"
#include "KorbOrbPacket.hh"


class TKorbBroker {
  public:
    enum TMethodId {
	MethodId_LaunchChildBroker,
	MethodId_LaunchProcess,
	MethodId_SendSignal,
	MethodId_SendUrgSignal,
	MethodId_Exit
    };
    static int PrimaryDomainId(void) { return 1; }
    static int AdapterId(void) { return TKorbNetworkHub::_AdapterId; }
    static char PathListSeparator(void) { return ':'; }
  public:
    TKorbBroker(const std::string& PathList = "");
    TKorbBroker(int DomainId, int ParentDomainId, const std::string& ParentHostName, int ParentPortNumber, const std::string& WorkingDirectory = "", const std::string& PathList = "");
    virtual ~TKorbBroker();
    virtual void Start(void) throw(TKorbException);
  protected:
    void Initialize(void) throw(TKorbException);
    void Finalize(void) throw(TKorbException);
    void LaunchNameServer(void) throw(TKorbException);
    void ConnectParent(void) throw(TKorbException);
    int ProcessOrbPacket(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    int LaunchChildBroker(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    int LaunchProcess(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    int SendSignal(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    int SendUrgSignal(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    int Exit(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    int _DomainId;
    int _ParentDomainId;
    std::string _ParentHostName;
    int _ParentPortNumber;
    TKorbNetworkHub* _NetworkHub;
    TKorbNetworkPacket _NetworkPacket;
    TMushChildProcess* _NameServerProcess;
    std::vector<TMushChildProcess*> _ChildProcessList;
    std::vector<std::string> _LaunchPathList;
    std::vector<TMushSocket*> _SocketList;
    std::string _HostName;
    std::string _RemoteShell;
    std::string _WorkingDirectory;
    std::string _PathListString;
    int _NextPortNumber;
};


#endif

