/* KorbCommander.hh */
/* Created by Enomoto Sanshiro on 2 March 2000. */
/* Last updated by Enomoto Sanshiro on 2 March 2000. */


#ifndef __KorbCommander_hh__
#define __KorbCommander_hh__


#include <string>
#include <vector>
#include "MushProcess.hh"
#include "KorbDefs.hh"
#include "KorbNetworkAdapter.hh"
#include "KorbNetworkPacket.hh"
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"


class TKorbCommander {
  public:
    TKorbCommander(TKorbOrb* Orb);
    virtual ~TKorbCommander();
    virtual int LaunchBroker(const std::string& ProcessPathList = "") throw(TKorbException);
    virtual int LaunchRemoteBroker(int ParentDomainId, const std::string& HostName, const std::string& ProcessPathList = "") throw(TKorbException);
    virtual int LaunchProcess(int DomainId, const std::string& Path, const std::vector<std::string>& ArgumentList) throw(TKorbException);
    virtual int SendSignal(int DomainId, int ProcessId, int SignalId) throw(TKorbException);
    virtual int TerminateBroker(int DomainId = 1) throw(TKorbException);
  protected:
    virtual TKorbOrbPacket CreateOrbPacket(int MethodId);
    virtual void InvokeBrokerMethod(int DomainId, TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:    
    TMushChildProcess* _BrokerProcess;
    TKorbOrb* _Orb;
};


#endif

