/* KorbNameServer.cc */
/* Created by Enomoto Sanshiro on 26 February 2000. */
/* Last updated by Enomoto Sanshiro on 26 February 2000. */


#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectMessenger.hh"
#include "KorbNamingContext.hh"
#include "KorbNameServer.hh"

using namespace std;



TKorbNameServer::TKorbNameServer(void)
{    
    int AdapterId = TKorbNamingContext::GetInitialReference().AdapterId();
    int ObjectId = TKorbNamingContext::GetInitialReference().ObjectId();

    _Orb = new TKorbOrb(AdapterId);
	
    _NamingContext = new TKorbNamingContext();
    _Messenger = new TKorbNamingContextMessenger(_NamingContext);

    _ObjectAdapter = _Orb->ObjectAdapter();
    _ObjectAdapter->AddMessenger(_Messenger, ObjectId);
}

TKorbNameServer::~TKorbNameServer() 
{
    delete _Messenger;
    delete _Orb;
    delete _NamingContext;
}

void TKorbNameServer::Start(void) throw(TKorbException)
{
    _ObjectAdapter->Start();
}
