/* KorbNetworkPacket.hh */
/* Created by Enomoto Sanshiro on 4 December 1999. */
/* Last updated by Enomoto Sanshiro on 4 February 2000. */


#ifndef __KorbNetworkPacket_hh__
#define __KorbNetworkPacket_hh__

#include <iostream>
#include "MushSocket.hh"


class TKorbNetworkPacket {
  public:
    enum TPacketTypeId {
        ptMessage = 0x00000101,
        ptRoutingQuery = 0x00000202,
        ptRoutingReply = 0x00000303,
        ptEchoRequest = 0x00000404,
        ptEchoReply = 0x00000505,
	_PacketTypeMask = 0x0000ffff
    };
    enum TDeliverStatus {
	dsOk = 0,
	dsNoRoute = 0x0001
    };
  public:
    TKorbNetworkPacket(void);
    TKorbNetworkPacket(const TKorbNetworkPacket& Packet);
    TKorbNetworkPacket& operator= (const TKorbNetworkPacket& Packet);
    virtual ~TKorbNetworkPacket();
    virtual void Dump(std::ostream& os);
  public:
    /* Message packet manipulation */
    virtual void SetReceiver(int DomainId, int AdapterId);
    virtual void SetSender(int DomainId, int AdapterId);
    virtual void SetData(const void* Data, int DataSize);
    virtual void SetDataSize(int DataSize);
    virtual void* AllocateDataArea(int MaxDataSize);
    virtual int ReceiverDomainId(void) const;
    virtual int ReceiverAdapterId(void) const;
    virtual int SenderDomainId(void) const;
    virtual int SenderAdapterId(void) const;
    virtual int DataSize(void) const;
    virtual void* DataArea(void);
    virtual int DataAreaCapacity(void) const;
  public:
    /* Routing packet manipulation */
    virtual void SetLookingDomainId(int LookingDomainId);
    virtual void SetRouteDomainId(int RouteDomainId);
    virtual void SetNumberOfSteps(int NumberOfSteps);
    virtual int LookingDomainId(void);
    virtual int RouteDomainId(void);
    virtual int NumberOfSteps(void);
  public:
    /* Direct access (for NetworkAdapter, NetworkHub) */
    virtual void SetPacketType(int PacketType);
    virtual void SetDeliverStatus(int DeliverStatus);
    virtual int PacketType(void) const;
    virtual int DeliverStatus(void) const;
    virtual void* ContentsAddress(void);
    virtual int ContentsSize(void) const;
    virtual int ContentsCapacity(void) const;
    virtual void AllocateBuffer(int BufferCapacity);
    virtual bool IsByteOrderReversed(void) const;
    virtual void ReverseByteOrder(void);
  protected:
    char* _Buffer;
    int _BufferCapacity;
    int _HeaderSize;
};


#endif
