/* KorbNetworkRoutingTable.hh */
/* Created by Enomoto Sanshiro on 4 December 1999. */
/* Last updated by Enomoto Sanshiro on 7 February 2000. */


#ifndef __KorbNetworkRoutingTable_hh__
#define __KorbNetworkRoutingTable_hh__


#include <map>
#include "KorbDefs.hh"
#include "KorbNetworkPacket.hh"


class TRoutingInformation;
class TSearchingEntry;
class TKorbNetworkHub;


class TKorbNetworkRoutingTable {
  public:
    enum TLookupResult {
	lrNoRoute = -1,
	lrSearching = -2
    };
  public:
    TKorbNetworkRoutingTable(TKorbNetworkHub* NetworkHub);
    virtual ~TKorbNetworkRoutingTable();
    virtual void AddConnection(int UplinkPortId, int RemoteDomainId);
    virtual int LookupRouteTo(int RemoteDomainId) throw(TKorbException);
    virtual int ProcessRoutingPacket(TKorbNetworkPacket& Packet, int UplinkPortId) throw(TKorbException);
  protected:
    virtual int ProcessRoutingQueryPacket(TKorbNetworkPacket& RoutingPacket, int UplinkPortId) throw(TKorbException);
    virtual int ProcessRoutingReplyPacket(TKorbNetworkPacket& RoutingPacket, int UplinkPortId) throw(TKorbException);
    virtual void Search(TKorbNetworkPacket& RoutingPacket, int ClientPortId = -1) throw(TKorbException);
    virtual void AddRouteToCache(int RemoteDomainId, int RouteDomainId, int NumberOfSteps);
  protected:
    TKorbNetworkHub* _NetworkHub;
    int _LocalDomainId;
    std::map<int, int> _UplinkTable;
    std::map<int, TRoutingInformation*> _CacheTable;
    std::map<int, TSearchingEntry*> _SearchingTable;
};


#endif
