/* KorbObjectReference.cc */
/* Created by Enomoto Sanshiro on 21 February 2000. */
/* Last updated by Enomoto Sanshiro on 21 February 2000. */


#include "KorbSerializer.hh"
#include "KorbObjectReference.hh"

using namespace std;


TKorbObjectReference::TKorbObjectReference(void)
{
    _ClassName = "";
    _ObjectName = "";
    _DomainId = -1;
    _AdapterId = -1;
    _ObjectId = -1;
}

TKorbObjectReference::TKorbObjectReference(const string& ClassName, const string& ObjectName, int DomainId, int AdapterId, int ObjectId)
{
    _ClassName = ClassName;
    _ObjectName = ObjectName;
    _DomainId = DomainId;
    _AdapterId = AdapterId;
    _ObjectId = ObjectId;
}

TKorbObjectReference::TKorbObjectReference(const TKorbObjectReference& ObjectReference)
{
    _ClassName = ObjectReference._ClassName;
    _ObjectName = ObjectReference._ObjectName;
    _DomainId = ObjectReference._DomainId;
    _AdapterId = ObjectReference._AdapterId;
    _ObjectId = ObjectReference._ObjectId;
}

TKorbObjectReference& TKorbObjectReference::operator= (const TKorbObjectReference& ObjectReference)
{
    _ClassName = ObjectReference._ClassName;
    _ObjectName = ObjectReference._ObjectName;
    _DomainId = ObjectReference._DomainId;
    _AdapterId = ObjectReference._AdapterId;
    _ObjectId = ObjectReference._ObjectId;

    return *this;
}

TKorbObjectReference::~TKorbObjectReference()
{
}

int TKorbObjectReference::WriteTo(void* Buffer, int BufferSize) const
{
    TKorbSerializer Serializer(Buffer, BufferSize);

    Serializer.PutInt(_DomainId);
    Serializer.PutInt(_AdapterId);
    Serializer.PutInt(_ObjectId);
    Serializer.PutString(_ClassName);
    Serializer.PutString(_ObjectName);

    return Serializer.ProcessedSize();
}

int TKorbObjectReference::ReadFrom(void* Buffer, int BufferSize)
{
    TKorbSerializer Serializer(Buffer, BufferSize);

    Serializer.GetInt(_DomainId);
    Serializer.GetInt(_AdapterId);
    Serializer.GetInt(_ObjectId);
    Serializer.GetString(_ClassName);
    Serializer.GetString(_ObjectName);

    return Serializer.ProcessedSize();
}

string TKorbObjectReference::ClassName(void) const
{
    return _ClassName;
}

string TKorbObjectReference::ObjectName(void) const
{
    return _ObjectName;
}

int TKorbObjectReference::DomainId(void) const
{
    return _DomainId;
}

int TKorbObjectReference::AdapterId(void) const
{
    return _AdapterId;
}

int TKorbObjectReference::ObjectId(void) const
{
    return _ObjectId;
}

bool TKorbObjectReference::IsNull(void) const
{
    return (_ObjectId < 0);
}
