/* KorbObjectReference.hh */
/* Created by Enomoto Sanshiro on 21 February 2000. */
/* Last updated by Enomoto Sanshiro on 21 February 2000. */


#ifndef __KorbObjectReference_hh__
#define __KorbObjectReference_hh__

#include <string>
#include "KorbStreamable.hh"


class TKorbObjectReference: public TKorbStreamable {
  public:
    TKorbObjectReference(void);
    TKorbObjectReference(const std::string& ClassName, const std::string& ObjectName, int DomainId, int AdapterId, int ObjectId);
    TKorbObjectReference(const TKorbObjectReference& ObjectReference);
    TKorbObjectReference& operator= (const TKorbObjectReference& ObjectReference);
    virtual ~TKorbObjectReference();
    virtual int WriteTo(void* Buffer, int BufferSize) const;
    virtual int ReadFrom(void* Buffer, int BufferSize);
    virtual std::string ClassName(void) const;
    virtual std::string ObjectName(void) const;
    virtual int DomainId(void) const;
    virtual int AdapterId(void) const;
    virtual int ObjectId(void) const;
    virtual bool IsNull(void) const;
  protected:
    std::string _ClassName;
    std::string _ObjectName;
    int _DomainId;
    int _AdapterId;
    int _ObjectId;
};


#endif

