/* KorbSerializer.hh */
/* Created by Enomoto Sanshiro on 21 February 2000. */
/* Last updated by Enomoto Sanshiro on 22 February 2000. */


#ifndef __KorbSerializer_hh__
#define __KorbSerializer_hh__

#include <string>

class TKorbStreamable;


class TKorbSerializer {
  public:
    TKorbSerializer(void);
    TKorbSerializer(void* Buffer, int BufferSize);
    TKorbSerializer(const TKorbSerializer& Serializer);
    TKorbSerializer& operator= (const TKorbSerializer& Serializer);
    virtual ~TKorbSerializer();
    virtual int ProcessedSize(void) const;
    virtual void Rewind(void);
    virtual int PutInt(int Value);
    virtual int GetInt(int& Value);
    virtual int PutLong(long Value);
    virtual int GetLong(long& Value);
    virtual int PutString(const std::string& Value);
    virtual int GetString(std::string& Value);
    virtual int PutObject(const TKorbStreamable& StreamableObject);
    virtual int GetObject(TKorbStreamable& StreamableObject);
  protected:
    void* _Buffer;
    int _BufferSize;
    int _Offset;
};


#endif

