/* logbook-server.cc */
/* Created by Enomoto Sanshiro on 23 February 2000. */
/* Last updated by Enomoto Sanshiro on 23 February 2000. */


#include <iostream>
#include "KorbOrb.hh"
#include "KorbObjectMessenger.hh"
#include "KorbNamingContext.hh"
#include "LogBookOrb.hh"

using namespace std;


class TLogBookServer {
  public:
    TLogBookServer(void);
    virtual ~TLogBookServer();
    virtual void Start(void) throw(TKorbException);
  protected:
    TKorbOrb* _Orb;
    TKorbObjectAdapter* _ObjectAdapter;
    TKorbObjectMessenger* _LogBookMessenger;
    TLogBook* _LogBook;
};


TLogBookServer::TLogBookServer(void)
{
    _Orb = new TKorbOrb();

    _LogBook = new TLogBook();
    _LogBookMessenger = new TLogBookMessenger(_LogBook);

    _ObjectAdapter = _Orb->ObjectAdapter();
    _ObjectAdapter->AddMessenger(_LogBookMessenger, "LogBook");
}

TLogBookServer::~TLogBookServer() 
{
    delete _LogBookMessenger;
    delete _LogBook;
    delete _Orb;
}

void TLogBookServer::Start(void) throw(TKorbException)
{
    _ObjectAdapter->Start();
}


int main(int argc, char **argv)
{
    try {
	TLogBookServer().Start();
    }
    catch (TKorbException& e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
