/* MushArgumentList.hh */
/* Created by Enomoto Sanshiro on 8 July 2000. */
/* Last updated by Enomoto Sanshiro on 8 July 2000. */


#ifndef __MushArgumentList_hh__
#define __MushArgumentList_hh__


#include <iostream>
#include <string>
#include <deque>
#include <map>
#include <set>
#include "MushDefs.hh"


class TMushArgumentList {
  public:
    TMushArgumentList(int argc, char** argv);
    virtual ~TMushArgumentList();
    virtual std::string ProgramName(void);
    virtual const std::deque<std::string>& ParameterList(void);
    virtual const std::set<char>& SwitchSet(void);
    virtual const std::map<std::string, std::string>& OptionTable(void);
  public:
    virtual int NumberOfParameters(void);
    virtual void ExpectParameters(int NumberOfExpectedParameters) throw(TSystemCallException);
    virtual std::string ParameterOf(int Index);
    virtual std::string operator[] (int Index);
    virtual long IntParameterOf(int Index) throw(TSystemCallException);
    virtual double FloatParameterOf(int Index) throw(TSystemCallException);
  public:
    virtual bool IsSwitchSpecified(char SwitchCharacter);
  public:
    virtual bool IsOptionSpecified(const std::string& OptionName, char EquivalentSwitchCharacter = '\0');
    virtual std::string OptionValueOf(const std::string& Name, const std::string& DefaultValue = "");
    virtual std::string operator[] (const std::string& Name);
    virtual long IntOptionValueOf(const std::string& Name) throw(TSystemCallException);
    virtual long IntOptionValueOf(const std::string& Name, long DefaultValue) throw(TSystemCallException);
    virtual double FloatOptionValueOf(const std::string& Name) throw(TSystemCallException);
    virtual double FloatOptionValueOf(const std::string& Name, double DefaultValue) throw(TSystemCallException);
  public:
    virtual std::string RemoveParameter(int Index = 0, int Count = 1);
    virtual void InsertParameter(const std::string& Parameter, int Index = -1);
    virtual std::string RemoveOption(const std::string& Name);
    virtual void AddOption(const std::string& Name, const std::string& Value = "");
    virtual void Dump(std::ostream& os);
  protected:
    virtual void Parse(void);
  protected:
    int _argc;
    char** _argv;
    bool _IsParsed;
    std::string _ProgramName;
    std::deque<std::string> _ParameterList;
    std::map<std::string, std::string> _OptionTable;
    std::set<char> _SwitchSet;
};


#endif
