/* MushCheckSum.hh */
/* Created by Enomoto Sanshiro on 15 February 2002. */
/* Last updated by Enomoto Sanshiro on 15 February 2002. */


#ifndef __MushCheckSum_hh__
#define __MushCheckSum_hh__


class TMushCheckSum {
  public:
    TMushCheckSum(void) {}
    virtual ~TMushCheckSum() {}
    virtual void ReadData(char* Data, int Size) = 0;
    virtual int DataLength(void) = 0;
    virtual int ResultLength(void) = 0;
    virtual unsigned char ByteValueAt(int Index) = 0;
};


class TMushCrc32CheckSum: public TMushCheckSum {
  public:
    TMushCrc32CheckSum(void);
    virtual ~TMushCrc32CheckSum();
    virtual void ReadData(char* Data, int Size);
    virtual int DataLength(void);
    virtual int ResultLength(void);
    virtual unsigned char ByteValueAt(int Index);
  protected:
    static unsigned long _CrcTable[256];
    static bool _IsCrcTableComputed;
    unsigned long _CrcValue;
    long _DataLength;
};


class TMushMd5CheckSum: public TMushCheckSum {
};


#endif
