/* MushConsole.cc */
/* Created by Enomoto Sanshiro on 29 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 November 2000. */


#include <cstdio>
#include <cstring>
#include <iostream>
#include <string>
#include "MushDefs.hh"
#include "MushConfig.hh"
#include "MushConsole.hh"

#if USE_READLINE
#undef HAVE_CONFIG_H
extern "C" {
#include <readline/readline.h>
#include <readline/history.h>
};
#endif

using namespace std;



TMushConsole::TMushConsole(void)
{
    _Prompt = 0;
}

TMushConsole::~TMushConsole()
{
    delete[] _Prompt;
}

string TMushConsole::SetPrompt(const string& Prompt)
{
    string OldPrompt;

    if (_Prompt != 0) {
	OldPrompt = _Prompt;
	delete[] _Prompt;
    }
    _Prompt = new char[Prompt.size() + 1];
    strcpy(_Prompt, Prompt.c_str());

    return OldPrompt;
}

bool TMushConsole::GetLine(string& Line)
{
    if (_Prompt != 0) {
	cout << _Prompt << flush;
    }

    return (bool) getline(cin, Line);
}

bool TMushConsole::GetLineTo(char* Buffer, size_t MaxSize)
{
    if (_Prompt != 0) {
	cout << _Prompt << flush;
    }

    return (bool) cin.getline(Buffer, MaxSize);
}

void TMushConsole::Put(const char* Buffer, size_t Size)
{
    cout.write(Buffer, Size);
}



TMushReadlineConsole::TMushReadlineConsole(void)
{
#if USE_READLINE
    // disables <TAB> completion //
    //rl_bind_key('\t', (Function*) rl_insert); 
#endif
}

TMushReadlineConsole::~TMushReadlineConsole()
{
}

bool TMushReadlineConsole::GetLine(string& Line)
{
#if USE_READLINE
    char* Buffer = readline(_Prompt);     // EOF returns NULL
    if (Buffer != 0) {
	if (Buffer[0] != '\0') {
	    add_history(Buffer);
	}
	Line = Buffer;
	free(Buffer);
    }

    return (Buffer != 0);

#else
    return TMushConsole::GetLine(Line);
#endif
}

bool TMushReadlineConsole::GetLineTo(char* Buffer, size_t MaxSize)
{
#if USE_READLINE
    char* Line = readline(_Prompt);     // EOF returns NULL
    if (Line != 0) {
	if (Line[0] != '\0') {
	    add_history(Line);
	}
	strncpy(Buffer, Line, MaxSize - 1);
	free(Line);
    }

    return (Line != 0);
#else
    return TMushConsole::GetLineTo(Buffer, MaxSize);
#endif
}

