/* MushConsoleStream.cc */
/* Created by Enomoto Sanshiro on 13 December 2001. */
/* Last updated by Enomoto Sanshiro on 13 December 2001. */


#include <iostream>
#include <cstring>
#include <string>
#include "MushConsole.hh"
#include "MushConsoleStream.hh"

using namespace std;


static const int DefaultBufferSize = 4096;


TMushConsoleStreamBuffer::TMushConsoleStreamBuffer(TMushConsole* Console)
{
    _Console = Console;

    _BufferSize = DefaultBufferSize;
    _Buffer = new char[_BufferSize];
    
    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);
    setg(Begin, End, End);
}

TMushConsoleStreamBuffer::~TMushConsoleStreamBuffer()
{
    delete[] _Buffer;
}

int TMushConsoleStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TMushConsoleStreamBuffer::underflow(void)
{
    if (! _Console->GetLineTo(_Buffer, _BufferSize)) {
        return EOF;
    }
    int Size = strlen(_Buffer);
    _Buffer[Size++] = '\n';

    char* Begin = _Buffer;
    char* Next = _Buffer;
    char* End = _Buffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TMushConsoleStreamBuffer::sync(void) 
{
    if (pptr() == _Buffer) {
	return 0;
    }

    int Length = pptr() - _Buffer;
    _Console->Put(_Buffer, Length);

    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TMushInputConsoleStream::TMushInputConsoleStream(TMushConsole* Console)
: istream(_StreamBuffer = new TMushConsoleStreamBuffer(Console))
{
}

TMushInputConsoleStream::~TMushInputConsoleStream() 
{
    delete _StreamBuffer;
}

TMushConsoleStreamBuffer* TMushInputConsoleStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}



TMushOutputConsoleStream::TMushOutputConsoleStream(TMushConsole* Console)
: ostream(_StreamBuffer = new TMushConsoleStreamBuffer(Console))
{
}

TMushOutputConsoleStream::~TMushOutputConsoleStream() 
{
    delete _StreamBuffer;
}

TMushConsoleStreamBuffer* TMushOutputConsoleStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
