/* MushDecoratedSocket.hh */
/* Created by Enomoto Sanshiro on 6 June 1999. */
/* Last updated by Enomoto Sanshiro on 4 December 2000. */


#ifndef __MushDecoratedSocket_hh__
#define __MushDecoratedSocket_hh__


#include "MushSocket.hh"
#include "MushDataEncoder.hh"



class TMushDecoratedSocket: public TMushSocket {
  public:
    TMushDecoratedSocket(TMushSocket *ComponentSocket);
    virtual ~TMushDecoratedSocket();
    virtual TSocketStatus Status(void) const;
    virtual void Open(void) throw(TSystemCallException);
    virtual void Close(void);
    virtual int Send(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Receive(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual bool IsServer(void) const;
    virtual int FileDescriptor(void) const;
  protected:
    TMushSocket *_ComponentSocket;
};


// With using this class, you can receive exactly the same packet 
// which was sent.
// i.e., packets would not be combined nor split.
class TMushFramedSocket: public TMushDecoratedSocket {
  public:
    TMushFramedSocket(TMushSocket *ComponentSocket);
    virtual ~TMushFramedSocket();
    virtual int Send(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Receive(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int NextPacketSize(void) throw(TSystemCallException);
  protected:
    static int ReceiveBlock(TMushSocket* Socket, void *Buffer, size_t Length) throw(TSystemCallException);
  protected:
    int _NextPacketSize;
  protected:
    enum {
	_HeaderSize = 4
    };
};


// The component socket should be a instance of TMushFramedSocket
// because fragmentation would be critical.
// (note that the data size could be changed on the encoding process)
class TMushEncodedSocket: public TMushDecoratedSocket {
  public:
    TMushEncodedSocket(TMushSocket *ComponentSocket, TMushDataEncoder* DataEncoder);
    virtual ~TMushEncodedSocket();
    virtual int Send(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Receive(void *Buffer, size_t Length) throw(TSystemCallException);
  protected:
    TMushDataEncoder* _DataEncoder;
    size_t _WorkAreaSize;
    char* _WorkArea;
};


#endif
