/* MushDomesticSocket.cc */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 19 November 1999. */


#include <iostream>
#include <strstream>
#include <string>
#include <unistd.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <errno.h>

#include <sys/socket.h>
#include <sys/un.h>

#include "MushDomesticSocket.hh"


using namespace std;


TMushDomesticSocket::TMushDomesticSocket(string SocketPath)
{
    _SocketPath = SocketPath;
}

TMushDomesticSocket::~TMushDomesticSocket()
{
}

string TMushDomesticSocket::Path(void) const
{
    return _SocketPath;
}



TMushServerDomesticSocket::TMushServerDomesticSocket(string SocketPath)
: TMushDomesticSocket(SocketPath)
{
}

TMushServerDomesticSocket::~TMushServerDomesticSocket()
{
    Close();
    unlink(_SocketPath.c_str());
}

void TMushServerDomesticSocket::Create(void) throw(TSystemCallException)
{
    if (_SocketStatus == ssInitial) {
	_ListenSocket = socket(AF_UNIX, SOCK_STREAM, 0);
	if (_ListenSocket < 0) {
	    throw TSystemCallException(
		"TMushServerDomesticSocket::Create(): socket(3N)"
	    );
	}
	_SocketStatus = ssCreated;
    }

    if (_SocketStatus != ssCreated) {
	throw TSystemCallException(
            "TMushServerDomesticSocket::Create()",
            "bad socket status to create"
        );
    }
}

void TMushServerDomesticSocket::Bind(void) throw(TSystemCallException)
{
    if (_SocketStatus == ssInitial) {
	Create();
    }

    if (_SocketStatus == ssCreated) {
	struct sockaddr_un SocketAddress;
	SocketAddress.sun_family = AF_UNIX;
	strcpy(SocketAddress.sun_path, _SocketPath.c_str());

        int BindResult = bind(
            _ListenSocket,
            (struct sockaddr *) &SocketAddress,
            sizeof(SocketAddress)
        );
	if (BindResult < 0) {
	    throw TSystemCallException(
                "TMushServerDomesticSocket::Bind(): "
                "bind(3N)"
            );
	}
	_SocketStatus = ssBound;
    }

    if (_SocketStatus != ssBound) {
	throw TSystemCallException(
            "TMushServerDomesticSocket::Bind()",
            "bad socket status to bind"
        );
    }
}

void TMushServerDomesticSocket::Accept(void) throw(TSystemCallException)
{
    if (_SocketStatus == ssListening) {
	struct sockaddr_un ClientSocketAddress;
#if ADDRLEN_IS_UNSIGNED
	size_t AddressLength = sizeof(ClientSocketAddress);
#else
	int AddressLength = sizeof(ClientSocketAddress);
#endif
	_ConnectSocket = accept(
	    _ListenSocket, 
	    (struct sockaddr *) &ClientSocketAddress, 
	    &AddressLength
	);
	if (_ConnectSocket < 0) {
	    throw TSystemCallException(
                "TMushServerDomesticSocket::Accept(): accept(3N)"
            );
	}

	_SocketStatus = ssOpened;
	close(_ListenSocket);
    }
    else {
	throw TSystemCallException(
            "TMushServerDomesticSocket::Accept()",
            "bad socket status to accept"
        );
    }
}



TMushClientDomesticSocket::TMushClientDomesticSocket(string SocketPath)
: TMushDomesticSocket(SocketPath)
{
}

void TMushClientDomesticSocket::Create(void) throw(TSystemCallException)
{
    if (_SocketStatus == ssInitial) {
	_ConnectSocket = socket(AF_UNIX, SOCK_STREAM, 0);
	if (_ConnectSocket < 0) {
	    throw TSystemCallException(
		"TMushClientDomesticSocket::Create(): socket(3N)"
	    );
	}
	_SocketStatus = ssCreated;
    }

    if (_SocketStatus != ssCreated) {
	throw TSystemCallException(
            "TMushClientDomesticSocket::Create()",
            "bad socket status to create"
        );
    }
}

void TMushClientDomesticSocket::Connect(void) throw(TSystemCallException)
{
    if (_SocketStatus == ssInitial) {
	Create();
    }

    if (_SocketStatus != ssCreated) {
	throw TSystemCallException(
            "TMushClientDomesticSocket::Connect()",
            "bad socket status to connect"
        );
    }

    struct sockaddr_un ServerSocketAddress;
    ServerSocketAddress.sun_family = AF_UNIX;
    strcpy(ServerSocketAddress.sun_path, _SocketPath.c_str());
    
    if (
        connect(
	    _ConnectSocket, 
	    (struct sockaddr *) &ServerSocketAddress, 
            sizeof(ServerSocketAddress)
	) < 0
    ){
	throw TSystemCallException(
            "TMushClientDomesticSocket::Connect(): "
            "connect(3N)"
        );
    }

    _SocketStatus = ssOpened;
}
