/* MushIpc.hh */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 3 July 1998. */


#ifndef __MushIpc_hh__
#define __MushIpc_hh__

#include <string>
#include <sys/types.h>
#include "MushDefs.hh"


class TMushSystemVIpc {
  protected:
    TMushSystemVIpc(int ProjectId, const std::string& ProjectPath);
    virtual ~TMushSystemVIpc();
    virtual int ProjectId();
    virtual std::string ProjectPath(void);
    virtual key_t IpcKey(void) throw(TSystemCallException);
    virtual int IpcId(void) throw(TSystemCallException);
  protected:
    int _IpcId;
  private:
    int _ProjectId;
    std::string _ProjectPath;
    key_t _IpcKey;
};



struct TMushMessageQueuePacket {
    long MessageType;
    char *MessageText;
};


class TMushMessageQueue: public TMushSystemVIpc {
  public:
    TMushMessageQueue(int ProjectId, const std::string& ProjectPath);
    virtual ~TMushMessageQueue();
    virtual int Send(const TMushMessageQueuePacket *MessageQueuePacket, int MessageLength) throw(TSystemCallException);
    virtual int Receive(TMushMessageQueuePacket *MessageQueuePacket, int MaxMessageLength, bool NoWait = false) throw(TSystemCallException);
    virtual int QueueCapacity(void) throw(TSystemCallException);
    virtual int NumberOfPendingPackets(void) throw(TSystemCallException);
    virtual void SetAddress(long Address = -1);
    virtual long Address(void);
  protected:
    long _Address;
    int _Capacity;
};


class TMushServerMessageQueue: public TMushMessageQueue {
  public:
    TMushServerMessageQueue(int ProjectId, const std::string& ProjectPath = "", unsigned AccessPermission = 0600, bool IsSelfish = false) throw(TSystemCallException);
    virtual ~TMushServerMessageQueue();
};


class TMushClientMessageQueue: public TMushMessageQueue {
  public:
    TMushClientMessageQueue(int ProjectId, const std::string& ProjectPath = "") throw(TSystemCallException);
    virtual ~TMushClientMessageQueue();
};



class TMushSharedMemory: public TMushSystemVIpc {
  public:
    TMushSharedMemory(int ProjectId, const std::string& ProjectPath);
    virtual ~TMushSharedMemory();
    virtual volatile void* BasePointer(void);
  protected:
    virtual void Attach(void) throw(TSystemCallException);
    virtual void Detach(void);
  protected:
    volatile void* _SharedMemoryAddress;
};


class TMushServerSharedMemory: public TMushSharedMemory {
  public:
    TMushServerSharedMemory(size_t Size, int ProjectId, const std::string& ProjectPath = "", unsigned AccessPermission = 0600, bool IsSelfish = false) throw(TSystemCallException);
    virtual ~TMushServerSharedMemory();
};


class TMushClientSharedMemory: public TMushSharedMemory {
  public:
    TMushClientSharedMemory(int ProjectId, const std::string& ProjectPath = "") throw(TSystemCallException);
    virtual ~TMushClientSharedMemory();
};


#endif
