/* MushMisc.hh */
/* Created by Enomoto Sanshiro on 28 May 1998. */
/* Last updated by Enomoto Sanshiro on 24 September 1998. */


#ifndef __MushMisc_hh__
#define __MushMisc_hh__


#include <string>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include "MushDefs.hh"


class TMushDateTime {
  public:
    enum TTimeZone {
	TimeZone_Local, TimeZone_GMT
    };
  public:
    TMushDateTime(TTimeZone TimeZone = TimeZone_Local);
    TMushDateTime(long TimeValue, TTimeZone TimeZone = TimeZone_Local);
    TMushDateTime& Update(void);
    long AsLong(void);
    long PassedTime(void);
    long PassedTimeMicroSec(void);
    std::string AsString(std::string TimeFormat = "");
    operator long () { return AsLong(); }
    long USec(void);
    int Sec(void);
    int Min(void);
    int Hour(void);
    int Day(void);
    int Month(void);
    int Year(void);
    int SecInDay(void);
    int DayInYear(void);
    int DayOfWeek(void);
    static long SecSinceEpoch(void) { return time(NULL); }
    static long SecSince(long Time) { return time(NULL) - Time; }
  protected:
    TTimeZone _TimeZone;
    struct timeval _TimeValue;
    struct tm _TimeStruct;
};


class TMushUser {
  public:
    TMushUser(void);
    TMushUser(long UserId) throw(TSystemCallException);
    TMushUser(const std::string& LoginName) throw(TSystemCallException);
    long Id(void);
    long GroupId(void);
    const char* Name(void);
    const char* GroupName(void);
    const char* HomeDir(void);
    const char* Shell(void);
  protected:
    long _UserId;
};


class TMushGroup {
  public:
    TMushGroup(void);
    TMushGroup(long GroupId) throw(TSystemCallException);
    TMushGroup(const std::string& GroupName) throw(TSystemCallException);
    long Id(void);
    const char* Name(void);
  protected:
    long _GroupId;
};


class TMushLocalHost {
  public:
    static const char* SystemName(void);
    static const char* SystemRelease(void);
    static const char* SystemVersion(void);
    static const char* HostName(void);
    static const char* Machine(void);
};


class TMushCpu {
  public:
    static bool IsLittleEndian(void);
};


class TMushEnvironmentVariable {
  public:
    TMushEnvironmentVariable(const std::string& Name);
    virtual ~TMushEnvironmentVariable();
    virtual std::string AsString(void) throw(TSystemCallException);
    virtual long AsLong(void) throw(TSystemCallException);
    virtual double AsDouble(void) throw(TSystemCallException);
    virtual operator const char* ();
    virtual operator const std::string& ();
  public:
    static std::string Get(const std::string& Name);
    static void Set(const std::string& Name, const std::string& Value);
    static bool IsDefined(const std::string& Name);
  protected:
    std::string _Name;
    std::string _Value;
};


#endif
