/* MushProcess.cc */
/* Created by Enomoto Sanshiro on 15 August 1998. */
/* Last updated by Enomoto Sanshiro on 28 July 2001. */


#include <iostream>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fcntl.h>
#include "MushProcess.hh"


using namespace std;


TMushProcess::TMushProcess(void)
{
    _ProcessId = getpid();
    _ParentProcessId = getppid();
}

TMushProcess::~TMushProcess()
{
}

long TMushProcess::ProcessId(void)
{
    return _ProcessId;
}

long TMushProcess::ParentProcessId(void)
{
    return _ParentProcessId;
}

long TMushProcess::Wait(long ProcessId)
{
    int State, Options = 0;
    long Result =  waitpid(ProcessId, &State, Options);
    if (Result < 0) {
	throw TSystemCallException("TMushProcess::Wait()");
    }

    return Result;
}



TMushChildProcess::TMushChildProcess(const string& FileName, const vector<string>& ArgumentList)
{
    _ParentProcessId = _ProcessId;
    _ProcessId = -1;
    _IsRunning = false;

    _FileName = FileName;
    LoadArgumentList(ArgumentList);
}

TMushChildProcess::TMushChildProcess(const vector<string>& PathList, const string& FileName, const vector<string>& ArgumentList)
{
    _ParentProcessId = _ProcessId;
    _ProcessId = -1;
    _IsRunning = false;

    _PathList = PathList;
    _FileName = FileName;
    LoadArgumentList(ArgumentList);
}

TMushChildProcess::~TMushChildProcess()
{
    for (int i = 0; _ArgumentList[i] != 0; i++) {
	delete[] _ArgumentList[i];
    }
    delete[] _ArgumentList;
}

void TMushChildProcess::LoadArgumentList(const vector<string>& ArgumentList)
{
    _ArgumentList = new char* [ArgumentList.size() + 1];

    for (unsigned i = 0; i < ArgumentList.size(); i++) {
        int Length = ArgumentList[i].length();
	_ArgumentList[i] = new char[Length + 1];
        for (int j = 0; j < Length; j++) {
            _ArgumentList[i][j] = ArgumentList[i][j];
        }
	_ArgumentList[i][Length] = '\0';
    }
    _ArgumentList[ArgumentList.size()] = 0;
}

long TMushChildProcess::Run(void) throw(TSystemCallException)
{
    string File = _FileName;

    if ((File[0] != '/') && ! _PathList.empty()) {
	unsigned PathIndex = 0;
	for (PathIndex = 0; PathIndex < _PathList.size(); PathIndex++) {
	    string FullPath = _PathList[PathIndex] + "/" + File;
	    if (access(FullPath.c_str(), X_OK) == 0) {
		File = FullPath;
		break;
	    }
	}
	if (PathIndex == _PathList.size()) {
	    throw TSystemCallException(
		"TMushChildProcess(\"" + File + "\", ...).Run()",
		"unable to find executable file"
	    );
	}
    }

    if ((File[0] == '/') && (access(File.c_str(), X_OK) < 0)) {
	throw TSystemCallException(
	    "TMushChildProcess(\"" + File + "\", ...).Run(): access(2)"
	);
    }

    _ProcessId = fork();
    if (_ProcessId == 0) {
	execvp(File.c_str(), _ArgumentList);
	_exit(EXIT_FAILURE);
    }

    _IsRunning = true;

    return _ProcessId;
}

void TMushChildProcess::WaitToExit(void)
{
    if (_IsRunning) {
	int State, Options = 0;
	waitpid(_ProcessId, &State, Options);
	
	if (! (WIFEXITED(State) || WIFSIGNALED(State))) {
	    WaitToExit();
	}
	
	_IsRunning = false;
    }
}

bool TMushChildProcess::IsRunning(void)
{
    if (! _IsRunning) {
	return false;
    }

    bool Result = _IsRunning;
    int State, Options = WNOHANG;
    if (waitpid(_ProcessId, &State, Options) == _ProcessId) {
	Result = ! (WIFEXITED(State) || WIFSIGNALED(State));
    }

    return Result;
}
