/* MushProcess.hh */
/* Created by Enomoto Sanshiro on 15 August 1998. */
/* Last updated by Enomoto Sanshiro on 28 July 2001. */


#ifndef __MushProcess_hh__
#define __MushProcess_hh__

#include <string>
#include <vector>
#include "MushDefs.hh"


class TMushProcess {
  public:
    TMushProcess(void);
    virtual ~TMushProcess();
    long ProcessId(void);
    long ParentProcessId(void);
    static long Wait(long ProcessId);
  protected:
    long _ProcessId;
    long _ParentProcessId;
};


class TMushChildProcess: public TMushProcess {
  public:
    TMushChildProcess(const std::string& FileName, const std::vector<std::string>& ArgumentList);
    TMushChildProcess(const std::vector<std::string>& PathList, const std::string& FileName, const std::vector<std::string>& ArgumentList);
    virtual ~TMushChildProcess();
    long Run(void) throw(TSystemCallException);
    void WaitToExit(void);
    bool IsRunning(void);
  private:
    void LoadArgumentList(const std::vector<std::string>& ArgumentList);
  protected:
    std::string _FileName;
    std::vector<std::string> _PathList;
    char** _ArgumentList;
    bool _IsRunning;
};

#endif
