/* MushRegularExpression.hh */
/* Created by Enomoto Sanshiro on 19 December 2000. */
/* Last updated by Enomoto Sanshiro on 10 June 2002. */


#ifndef __MushRegularExpression_hh__
#define __MushRegularExpression_hh__


#include <string>
#include <sys/types.h>
#include <regex.h>
#include "MushDefs.hh"


class TMushRegularExpression {
  public:
    TMushRegularExpression(void) {}
    virtual ~TMushRegularExpression() {}
    virtual bool Match(const std::string& String) throw(TSystemCallException) = 0;
    virtual int NumberOfSubMatchs(void) = 0;
    virtual std::string SubMatchOf(int Index) = 0;
    virtual bool FindPattern(const std::string& String, int& Offset, int& Size) throw(TSystemCallException) = 0;
    virtual std::string Substitute(const std::string& String, const std::string& SubstitutionString) throw(TSystemCallException) = 0;
    virtual std::string SubstituteAll(const std::string& String, const std::string& SubstitutionString) throw(TSystemCallException) = 0;
};


class TMushPosixRegularExpression: public TMushRegularExpression {
  public:
    TMushPosixRegularExpression(const std::string& Pattern, bool IsCaseInsensitive = false);
    virtual ~TMushPosixRegularExpression();
    virtual bool Match(const std::string& String) throw(TSystemCallException);
    virtual int NumberOfSubMatchs(void);
    virtual std::string SubMatchOf(int Index);
    virtual bool FindPattern(const std::string& String, int& Offset, int& Size) throw(TSystemCallException);
    virtual std::string Substitute(const std::string& String, const std::string& SubstitutionString) throw(TSystemCallException);
    virtual std::string SubstituteAll(const std::string& String, const std::string& SubstitutionString) throw(TSystemCallException);
  protected:
    virtual void CompilePattern(void) throw(TSystemCallException);
  protected:
    std::string _Pattern;
    bool _IsCaseInsensitive;
    regex_t* _CompiledPattern;
    std::string _CurrentString;
    int _NumberOfSubMatchs;
    regmatch_t* _SubMatchBuffer;
    bool _LastMatchResult;
};


#endif
