/* MushSignal.cc */
/* Created by Enomoto Sanshiro on 4 May 1998. */
/* Last updated by Enomoto Sanshiro on 2 Nobember 2000. */


#include <unistd.h>
#include <signal.h>
#include "MushSignal.hh"

using namespace std;


TMushSignalClient* TMushSignalHandler::_ClientList[NSIG];


TMushSignalHandler::TMushSignalHandler(void) 
{
    sigemptyset(&_SignalSet);
    sigemptyset(&_OldSignalSet);    
    _IsBlocking = false;
}

TMushSignalHandler::~TMushSignalHandler() 
{
}

void TMushSignalHandler::RegisterClient(int SignalId, TMushSignalClient* SignalClient) 
{
    if ((SignalId > 0) && (SignalId < NSIG)) {
	_ClientList[SignalId] = SignalClient;
	sigaddset(&_SignalSet, SignalId);
    }
    else if (SignalId == 0) {
	for (int i = 1; i < NSIG; i++) {
	    RegisterClient(i, SignalClient);
	}
    }
    else {
#if 0
	throw TSystemCallException(
	    "TMushSignalHandler::RegisterClient()", "invalid signal ID"
	);
#endif
    }
}

void TMushSignalHandler::StartHandling(int SignalId, bool RestartsSystemCall) 
{
    _SignalAction.sa_handler = Handler;
    _SignalAction.sa_mask = _SignalSet;
    _SignalAction.sa_flags = 0;
    
    if (RestartsSystemCall) {
	_SignalAction.sa_flags |= SA_RESTART;
    }

    SetSignalAction(SignalId, &_SignalAction);
}

void TMushSignalHandler::StartIgnoring(int SignalId) 
{
    _SignalAction.sa_handler = SIG_IGN;
    _SignalAction.sa_mask = _SignalSet;
    _SignalAction.sa_flags = 0;

    SetSignalAction(SignalId, &_SignalAction);
}

void TMushSignalHandler::StartDefaultAction(int SignalId) 
{
    _SignalAction.sa_handler = SIG_DFL;
    _SignalAction.sa_mask = _SignalSet;
    _SignalAction.sa_flags = 0;

    SetSignalAction(SignalId, &_SignalAction);
}

void TMushSignalHandler::StartBlocking(void) 
{
    if (! _IsBlocking) {
	sigprocmask(SIG_BLOCK, &_SignalSet, &_OldSignalSet);
	_IsBlocking = true;
    }
}

void TMushSignalHandler::StopBlocking(void) 
{
    if (_IsBlocking) {
	sigprocmask(SIG_SETMASK, &_OldSignalSet, 0);
	_IsBlocking = false;
    }
}

int TMushSignalHandler::HasPending(int SignalId)
{
    sigset_t PendingSet;
    sigpending(&PendingSet);
    
    return sigismember(&PendingSet, SignalId);
}

void TMushSignalHandler::Wait(void) 
{
    sigsuspend(&_OldSignalSet);
}

void TMushSignalHandler::Reset(void)
{
    StartDefaultAction();

    sigemptyset(&_SignalSet);
}

void TMushSignalHandler::SetSignalAction(int SignalId, struct sigaction* SignalAction)
{
    if (SignalId != 0) {
	sigaction(SignalId, SignalAction, 0);
    }
    else {
	for (SignalId = 1; SignalId < NSIG; SignalId++) {
	    if (sigismember(&_SignalSet, SignalId)) {
		SetSignalAction(SignalId, SignalAction);
	    }
	}
    }
}

void TMushSignalHandler::Handler(int SignalId) 
{
    if (_ClientList[SignalId] != 0) {
	_ClientList[SignalId]->OnCatchSignal(SignalId);
    }
}

int TMushSignalSender::Raise(int SignalId)
{
    return raise(SignalId);
}

int TMushSignalSender::SendSignal(long TargetProcessId, int SignalId)
{
    return kill(TargetProcessId, SignalId);
}
