/* MushSignal.hh */
/* Created by Enomoto Sanshiro on 4 May 1998. */
/* Last updated by Enomoto Sanshiro on 2 November 2000. */


#ifndef __MushSignal_hh__
#define __MushSignal_hh__

#include <signal.h>
#include "MushDefs.hh"


class TMushSignalClient {
  public:
    virtual void OnCatchSignal(int SignalId) = 0;
    typedef volatile sig_atomic_t TSignalFlag;
};

class TMushSignalCounter: public TMushSignalClient {
  public:
    TMushSignalCounter(void) {_SignalCount = 0;}
    virtual void OnCatchSignal(int SignalId) {++_SignalCount;}
    virtual int SignalCount(void) {return _SignalCount;}
    virtual void Reset(void) {_SignalCount = 0;}
    virtual void DecrimentCount(int n = 1) {_SignalCount -= n;}
  private:
    int _SignalCount;
};


class TMushSignalHandler {
  public:
    TMushSignalHandler(void);
    ~TMushSignalHandler();
    void RegisterClient(int SignalId, TMushSignalClient* SignalClient);
    void StartHandling(int SignalId = 0, bool RestartsSystemCall = false);
    void StartIgnoring(int SignalId = 0);
    void StartDefaultAction(int SignalId = 0);
    void StartBlocking(void);
    void StopBlocking(void);
    int HasPending(int SignalId);
    void Wait(void);
    void Reset(void);
  private:
    void SetSignalAction(int SignalId, struct sigaction* SignalAction);
  private:
    sigset_t _SignalSet, _OldSignalSet;
    struct sigaction _SignalAction;
    bool _IsBlocking;
  private:
    static void Handler(int SignalId);
    static TMushSignalClient* _ClientList[NSIG];
};


class TMushSignalSender {
  public:
    static int Raise(int SignalId);
    static int SendSignal(long TargetProcessId, int SignalId);
};


#endif
