/* MushSocketStream.cc */
/* Created by Enomoto Sanshiro on 14 May 2000. */
/* Last updated by Enomoto Sanshiro on 14 May 2000. */


#include <iostream>
#include <cstring>
#include <string>
#include "MushSocket.hh"
#include "MushSocketStream.hh"

using namespace std;


static const int DefaultBufferSize = 4096;


TMushSocketStreamBuffer::TMushSocketStreamBuffer(TMushSocket* Socket)
{
    _Socket = Socket;

    _BufferSize = DefaultBufferSize;
    _Buffer = new char[_BufferSize];
    
    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);
    setg(Begin, End, End);
}

TMushSocketStreamBuffer::~TMushSocketStreamBuffer()
{
    delete[] _Buffer;
}

int TMushSocketStreamBuffer::overflow(int ch)
{
    sync();

    if (ch != EOF) {
	*pptr() = ch;
	pbump(1);
    }
    
    return ch;
}

int TMushSocketStreamBuffer::underflow(void)
{
    int Size = _Socket->Receive(_Buffer, _BufferSize);
    if (Size == 0) {
        return EOF;
    }
    else if (Size < 0) {
	// interrupted system call... try again //
	return underflow();
    }

    char* Begin = _Buffer;
    char* Next = _Buffer;
    char* End = _Buffer + Size;
    setg(Begin, Next, End);

    return *gptr();
}

int TMushSocketStreamBuffer::sync(void) 
{
    if (pptr() == _Buffer) {
	return 0;
    }

    int Length = pptr() - _Buffer;
    _Socket->Send(_Buffer, Length);

    char* Begin = _Buffer;
    char* End = _Buffer + _BufferSize;
    setp(Begin, End);

    return 0;
}



TMushInputSocketStream::TMushInputSocketStream(TMushSocket* Socket)
: istream(_StreamBuffer = new TMushSocketStreamBuffer(Socket))
{
}

TMushInputSocketStream::~TMushInputSocketStream() 
{
    delete _StreamBuffer;
}

TMushSocketStreamBuffer* TMushInputSocketStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}


TMushOutputSocketStream::TMushOutputSocketStream(TMushSocket* Socket)
: ostream(_StreamBuffer = new TMushSocketStreamBuffer(Socket))
{
}

TMushOutputSocketStream::~TMushOutputSocketStream() 
{
    delete _StreamBuffer;
}

TMushSocketStreamBuffer* TMushOutputSocketStream::rdbuf(void) 
{ 
    return _StreamBuffer; 
}
