/* argument-list-test.cc */
/* Created by Enomoto Sanshiro on 8 July 2000. */
/* Last updated by Enomoto Sanshiro on 8 July 2000. */


#include <iostream>
#include "MushArgumentList.hh"

using namespace std;


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    cout << "ProgramName: " << endl;
    cout << "    " << ArgumentList.ProgramName() << endl;

    cout << "Parameters:" << endl;
    for (int i = 0; i < ArgumentList.NumberOfParameters(); i++) {
	cout << "    " << ArgumentList[i] << endl;
    }
    
    cout << "Options:" << endl;
    const map<string, string>& OptionTable = ArgumentList.OptionTable();
    map<string, string>::const_iterator OptionIterator;
    
    for (
	OptionIterator = OptionTable.begin();
	OptionIterator != OptionTable.end();
	OptionIterator++
    ){
	string OptionName = (*OptionIterator).first;
	string OptionValue = ArgumentList[OptionName];

	cout << "    " << OptionName << ": " << OptionValue << endl;
    }

    cout << "Switchs:" << endl;
    const set<char>& SwitchSet = ArgumentList.SwitchSet();
    set<char>::const_iterator SwitchIterator;

    for (
	SwitchIterator = SwitchSet.begin();
	SwitchIterator != SwitchSet.end();
	SwitchIterator++
    ){
	cout << "    " << *SwitchIterator << endl;
    }

    return 0;
}
