/* file-attribute-test.cc */
/* Created by Enomoto Sanshiro on 15 October 2001. */
/* Last updated by Enomoto Sanshiro on 15 October 2001. */


#include <iostream>
#include <string>
#include "MushFileSystem.hh"
#include "MushMisc.hh"

using namespace std;


int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "usage: " << argv[0] << " FileName" << endl;
	return -1;
    }
    string FileName = argv[1];

    TMushFileAttribute FileAttribute(FileName);
    try {
	cout << "Size: " << FileAttribute.Size() << endl;
	cout << "Owner: " << FileAttribute.OwnerUserId();
	cout << " (" << TMushUser(FileAttribute.OwnerUserId()).Name() << ")" << endl;
	cout << "Group: " << FileAttribute.OwnerGroupId();
	cout << " (" << TMushGroup(FileAttribute.OwnerGroupId()).Name() << ")" << endl;
	cout << "AccessMode: " << oct << FileAttribute.AccessMode() << dec << endl;
	cout << "LastAccess: " << TMushDateTime(FileAttribute.LastAccessTime()).AsString() << endl;
	cout << "LastModification: " << TMushDateTime(FileAttribute.LastModificationTime()).AsString() << endl;
	cout << "LastChange: " << TMushDateTime(FileAttribute.LastChangeTime()).AsString() << endl;
	cout << "IsFile: " << FileAttribute.IsFile() << endl;
	cout << "IsDirectory: " << FileAttribute.IsDirectory() << endl;
	cout << "IsSymbolicLink: " << FileAttribute.IsSymbolicLink() << endl;
	cout << "CheckSum: " << FileAttribute.CheckSum() << endl;
    }
    catch (TSystemCallException &e) {
	cout << e << endl;
    }
    cout << "IsReadable: " << FileAttribute.IsReadable() << endl;
    cout << "IsWritable: " << FileAttribute.IsWritable() << endl;
    cout << "IsExecutable: " << FileAttribute.IsExecutable() << endl;
    cout << "PathName: " << FileAttribute.PathName() << endl;
    cout << "FileName: " << FileAttribute.FileName() << endl;
    cout << "FileRootName: " << FileAttribute.FileRootName() << endl;
    cout << "Extension: " << FileAttribute.Extension() << endl;
    cout << endl;
    
    try {
	TMushFileSystem FileSystem(FileName);
	cout << "blocksize: " << FileSystem.BlockSize() << endl;
	cout << "total blocks: " << FileSystem.TotalNumberOfBlocks() << endl;
	cout << "free blocks: " << FileSystem.NumberOfFreeBlocks() << endl;
	cout << "available blocks: " << FileSystem.NumberOfAvailableBlocks() << endl;
	cout << "total nodes: " << FileSystem.TotalNumberOfNodes() << endl;
	cout << "free nodes: " << FileSystem.NumberOfFreeNodes() << endl;
    }
    catch (TSystemCallException &e) {
	cout << e << endl;
    }

    return 0;
}
