/* regular-expression-test.cc */
/* Created by Enomoto Sanshiro on 19 December 2000. */
/* Last updated by Enomoto Sanshiro on 10 June 2002. */


#include "MushRegularExpression.hh"
#include "MushArgumentList.hh"
#include "MushConsole.hh"

using namespace std;


int main(int argc, char **argv)
{
    TMushArgumentList ArgumentList(argc, argv);
    if (ArgumentList.NumberOfParameters() < 1) {
	cerr << "usage: " << ArgumentList.ProgramName() << " 'Pattern' [SubstitutionStirng]" << endl;
	return -1;
    }

    TMushReadlineConsole Console;
    Console.SetPrompt("> ");

    string Pattern = ArgumentList[0];
    string SubstitutionString = ArgumentList[1];
    TMushPosixRegularExpression RegularExpression(Pattern);

    string Line;
    while (Console.GetLine(Line)) {
	cout << "\"" << Line << "\" ";

	// basic matching test
	if (RegularExpression.Match(Line)) {
	    cout << "matchs";
	}
	else {
	    cout << "does not match";
	}
	cout << " \"" << Pattern << "\"" << endl;

	// subpattern matching test
	int NumberOfSubMatchs = RegularExpression.NumberOfSubMatchs();
	for (int Index = 0; Index < NumberOfSubMatchs; Index++) {
	    cout << Index << ": ";
	    cout << RegularExpression.SubMatchOf(Index) << endl;
	}

	// substitution test
	if (! SubstitutionString.empty()) {
	    cout << RegularExpression.SubstituteAll(Line, SubstitutionString) << endl;
	}
    }
    cout << endl;

    return 0;
}
