/* zlib-test.cc */
/* Created by Enomoto Sanshiro on 26 January 2002. */
/* Last updated by Enomoto Sanshiro on 26 January 2002. */


#include <iostream>
#include <fstream>
#include <string>
#include "MushDataCompressor.hh"

using namespace std;


void ShowUsage(void);
void Compress(istream& InputFile, ostream& OutputFile) throw (TSystemCallException);
void Decompress(istream& InputFile, ostream& OutputFile) throw (TSystemCallException);


int main(int argc, char** argv)
{
    if (argc != 4) {
	ShowUsage();
	return 0;
    }

    const char* InputFileName = argv[2];
    ifstream InputFile(InputFileName);
    if (! InputFile) {
	cerr << "unable to open file: " << InputFileName << endl;
	return 0;
    }

    const char* OutputFileName = argv[3];
    ofstream OutputFile(OutputFileName);
    if (! OutputFile) {
	cerr << "unable to open file: " << OutputFileName << endl;
	return 0;
    }

    try {
	if (string(argv[1]) == "-c") {
	    Compress(InputFile, OutputFile);
	}
	else if (string(argv[1]) == "-d") {
	    Decompress(InputFile, OutputFile);
	}
	else {
	    ShowUsage();
	}
    }
    catch (TSystemCallException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}


void ShowUsage(void)
{
    cerr << "usage: zlib-test flag infile outfile" << endl;
    cerr << "flag: " << endl;
    cerr << "  -c: compress" << endl;
    cerr << "  -d: decompress" << endl;
}


void Compress(istream& InputFile, ostream& OutputFile) throw (TSystemCallException)
{
    TMushZlibDataCompressor DataCompressor;

    static const size_t BufferSize = 4096;
    static char InputBuffer[BufferSize];
    static char OutputBuffer[BufferSize];
    int DataSize, CompressedSize;

    while (
	InputFile.read(InputBuffer, BufferSize), 
	((DataSize = InputFile.gcount()) > 0) 
    ){
	bool IsLast = InputFile.eof();
	DataCompressor.SetCompressInput(InputBuffer, DataSize, IsLast);

	while ((CompressedSize = DataCompressor.Compress(OutputBuffer, BufferSize)) > 0) {
	    OutputFile.write(OutputBuffer, CompressedSize);
	}
    }
}


void Decompress(istream& InputFile, ostream& OutputFile) throw (TSystemCallException)
{
    TMushZlibDataCompressor DataCompressor;

    static const size_t BufferSize = 4096;
    static char InputBuffer[BufferSize];
    static char OutputBuffer[BufferSize];
    int DataSize, DecompressedSize;

    while (
	InputFile.read(InputBuffer, BufferSize), 
	((DataSize = InputFile.gcount()) > 0) 
    ){
	bool IsLast = InputFile.eof();
	DataCompressor.SetDecompressInput(InputBuffer, DataSize, IsLast);

	while ((DecompressedSize = DataCompressor.Decompress(OutputBuffer, BufferSize)) > 0) {
	    OutputFile.write(OutputBuffer, DecompressedSize);
	}
    }
}


#if 0

#include "MushFileSystem.hh"
#include "MushDataEncoder.hh"


// The buffer size have to be greater than the file size. see below.
static const size_t BufferSize = 4096;
static char Buffer[BufferSize];


void Compress(istream& InputFile, ostream& OutputFile) throw (TSystemCallException)
{
    TMushZlibDataEncoder DataEncoder;

    void* EncodedData;
    size_t EncodedDataSize;
    size_t DataSize;

    // For consistent decompress, the following loop should be 
    // executed just once (decompress have to be applied to the same data
    // block as compressed).
    // Hence the buffer size should be bigger than the file size.
    // TMushFramedFile might be useful to compress data block by block.

    while (
	InputFile.read(Buffer, BufferSize), 
	((DataSize = InputFile.gcount()) > 0) 
    ){
	cout << "compress: " << DataSize << flush;
	DataEncoder.Encode(Buffer, DataSize, EncodedData, EncodedDataSize);

	cout << " -> " << EncodedDataSize << endl;
	OutputFile.write(EncodedData, EncodedDataSize);
    }
}


void Decompress(istream& InputFile, ostream& OutputFile) throw (TSystemCallException)
{
    TMushZlibDataEncoder DataEncoder;

    void* EncodedData;
    size_t EncodedDataSize;
    size_t DataSize;

    while (
	InputFile.read(Buffer, BufferSize), 
	((DataSize = InputFile.gcount()) > 0)
    ){
	cout << "decompress: " << DataSize << flush;
	DataEncoder.Decode(Buffer, DataSize, EncodedData, EncodedDataSize);

	cout << " -> " << EncodedDataSize << endl;
	OutputFile.write(EncodedData, EncodedDataSize);
    }
}
#endif
