
/* ParaMathLibrary.cc */
/* Created by Enomoto Sanshiro on 22 August 1999. */
/* Last updated by Enomoto Sanshiro on 12 April 2001. */


#include <string>
#include <vector>
#include <map>
#include <cmath>
#include <cstdlib>
#include "ParaObject.hh"
#include "ParaMathLibrary.hh"

using namespace std;


TParaMathObject::TParaMathObject(void)
: TParaObjectPrototype("Math")
{
}

TParaMathObject::~TParaMathObject()
{
}

TParaObjectPrototype* TParaMathObject::Clone(void)
{
    return new TParaMathObject();
}

int TParaMathObject::MethodIdOf(const std::string& MethodName)
{
    if (MethodName == "sin") {
        return MethodId_Sin;
    }
    else if (MethodName == "cos") {
        return MethodId_Cos;
    }
    else if (MethodName == "tan") {
        return MethodId_Tan;
    }
    else if (MethodName == "asin") {
        return MethodId_Asin;
    }
    else if (MethodName == "acos") {
        return MethodId_Acos;
    }
    else if (MethodName == "atan") {
        return MethodId_Atan;
    }
    else if (MethodName == "exp") {
        return MethodId_Exp;
    }
    else if (MethodName == "log") {
        return MethodId_Log;
    }
    else if (MethodName == "sqrt") {
        return MethodId_Sqrt;
    }
    else if (MethodName == "abs") {
        return MethodId_Abs;
    }
    else if (MethodName == "srand") {
        return MethodId_Srand;
    }
    else if (MethodName == "rand") {
        return MethodId_Rand;
    }

    return TParaObjectPrototype::MethodIdOf(MethodName);
}

int TParaMathObject::InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    int Result = 0;

    switch (MethodId) {
      case MethodId_Sin:
        Result = Sin(ArgumentList, ReturnValue);
        break;
      case MethodId_Cos:
        Result = Cos(ArgumentList, ReturnValue);
        break;
      case MethodId_Tan:
        Result = Tan(ArgumentList, ReturnValue);
        break;
      case MethodId_Asin:
        Result = Asin(ArgumentList, ReturnValue);
        break;  
      case MethodId_Acos:
        Result = Acos(ArgumentList, ReturnValue);
        break;
      case MethodId_Atan:
        Result = Atan(ArgumentList, ReturnValue);
        break;
      case MethodId_Exp:
        Result = Exp(ArgumentList, ReturnValue);
        break;
      case MethodId_Log:
        Result = Log(ArgumentList, ReturnValue);
        break;
      case MethodId_Sqrt:
        Result = Sqrt(ArgumentList, ReturnValue);
        break;
      case MethodId_Abs:
        Result = Abs(ArgumentList, ReturnValue);
        break;
      case MethodId_Srand:
        Result = Srand(ArgumentList, ReturnValue);
        break;
      case MethodId_Rand:
        Result = Rand(ArgumentList, ReturnValue);
        break;
      default:
	Result = 0;
    }

    return Result;
}

int TParaMathObject::Sin(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("sin(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	ReturnValue = TParaValue(sin(ArgumentList[0]->AsDouble()));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    ResultList.push_back(TParaValue((double) sin(x)));
	}
    }

    return 1;
}

int TParaMathObject::Cos(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("cos(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	ReturnValue = TParaValue(cos(ArgumentList[0]->AsDouble()));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    ResultList.push_back(TParaValue((double) cos(x)));
	}
    }

    return 1;
}

int TParaMathObject::Tan(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("tan(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	double x = ArgumentList[0]->AsDouble();
	if (cos(x) == 0) {
	    throw TScriptException("tan(): invalid argument");
	}
	ReturnValue = TParaValue(tan(ArgumentList[0]->AsDouble()));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    if (cos(x) == 0) {
		throw TScriptException("tan(): invalid argument");
	    }
	    double Value = tan(x);
	    ResultList.push_back(TParaValue(Value));
	}
    }

    return 1;
}

int TParaMathObject::Asin(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("asin(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	double x = ArgumentList[0]->AsDouble();
	if ((x < -1.0) || (x > 1.0)) {
	    throw TScriptException("asin(): invalid argument");
	}
	ReturnValue = TParaValue((double) asin(x));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    if ((x < -1.0) || (x > 1.0)) {
		throw TScriptException("asin(): invalid argument");
	    }
	    ResultList.push_back(TParaValue((double) asin(x)));
	}
    }

    return 1;
}

int TParaMathObject::Acos(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("acos(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	double x = ArgumentList[0]->AsDouble();
	if ((x < -1.0) || (x > 1.0)) {
	    throw TScriptException("acos(): invalid argument");
	}
	ReturnValue = TParaValue((double) acos(x));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    if ((x < -1.0) || (x > 1.0)) {
		throw TScriptException("acos(): invalid argument");
	    }
	    ResultList.push_back(TParaValue((double) acos(x)));
	}
    }

    return 1;
}

int TParaMathObject::Atan(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("atan(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	ReturnValue = TParaValue(atan(ArgumentList[0]->AsDouble()));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    ResultList.push_back(TParaValue((double) atan(x)));
	}
    }

    return 1;
}

int TParaMathObject::Exp(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("exp(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	ReturnValue = TParaValue(exp(ArgumentList[0]->AsDouble()));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    ResultList.push_back(TParaValue((double) exp(x)));
	}
    }

    return 1;
}

int TParaMathObject::Log(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("log(): incorrect number of argument[s]");
    }

    if (! ArgumentList[0]->IsList()) {
	double x = ArgumentList[0]->AsDouble();
	if (x <= 0) {
	    throw TScriptException("log(): invalid argument");
	}
	ReturnValue = TParaValue((double) log(x));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    if (x <= 0) {
		throw TScriptException("log(): invalid argument");
	    }
	    ResultList.push_back(TParaValue((double) log(x)));
	}
    }

    return 1;
}

int TParaMathObject::Sqrt(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("sqrt(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	double x = ArgumentList[0]->AsDouble();
	if (x < 0) {
	    throw TScriptException("sqrt(): invalid argument");
	}
	ReturnValue = TParaValue((double) sqrt(x));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    if (x < 0) {
		throw TScriptException("sqrt(): invalid argument");
	    }
	    ResultList.push_back(TParaValue((double) sqrt(x)));
	}
    }

    return 1;
}

int TParaMathObject::Abs(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if (ArgumentList.size() != 1) {
        throw TScriptException("abs(): incorrect number of argument[s]");
    }
    
    if (! ArgumentList[0]->IsList()) {
	ReturnValue = TParaValue(fabs(ArgumentList[0]->AsDouble()));
    }
    else {
	ReturnValue = TParaValue(TParaListValue());
	vector<TParaValue>& InputList = ArgumentList[0]->AsValueList();
	vector<TParaValue>& ResultList = ReturnValue.AsValueList();
	for (unsigned i = 0; i < InputList.size(); i++) {
	    double x = InputList[i].AsDouble();
	    ResultList.push_back(TParaValue((double) fabs(x)));
	}
    }

    return 1;
}

int TParaMathObject::Srand(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((ArgumentList.size() != 1) || ! (ArgumentList[0]->IsLong())) {
        throw TScriptException("srand(int): incorrect number of argument[s]");
    }

    srand48(ArgumentList[0]->AsLong());

    return 1;
}

int TParaMathObject::Rand(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    ReturnValue = TParaValue((double) drand48());

    return 1;
}
