/* ParaStandardLibrary.hh */
/* Created by Enomoto Sanshiro on 24 June 1999. */
/* Last updated by Enomoto Sanshiro on 24 March 2002. */


#ifndef __ParaStandardLibrary_hh__
#define __ParaStandardLibrary_hh__


#include <fstream>
#include <strstream>
#include <string>
#include <vector>
#include <map>
#include "ParaObject.hh"


class TParaConsoleObject: public TParaObjectPrototype {
  public:
    TParaConsoleObject(void);
    virtual ~TParaConsoleObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Print = TParaObjectPrototype::_NumberOfMethods,
	MethodId_PrintLine,
	MethodId_GetLine,
	MethodId_GetString,
	MethodId_GetByte,
	_NumberOfMethods
    };
  protected:
    int Print(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int PrintLine(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetLine(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetString(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetByte(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
};


class TParaInputFileObject: public TParaObjectPrototype {
  public:
    TParaInputFileObject(void);
    virtual ~TParaInputFileObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_GetLine = TParaObjectPrototype::_NumberOfMethods,
	MethodId_GetString,
	MethodId_GetByte,
	_NumberOfMethods
    };
  protected:
    int GetLine(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetString(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetByte(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
  private:
    std::ifstream* _FileStream;
};


class TParaOutputFileObject: public TParaObjectPrototype {
  public:
    TParaOutputFileObject(void);
    virtual ~TParaOutputFileObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Print = TParaObjectPrototype::_NumberOfMethods,
	MethodId_PrintLine,
	_NumberOfMethods
    };
  protected:
    int Print(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int PrintLine(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
  private:
    std::ofstream* _FileStream;
};


class TParaFormatterObject: public TParaObjectPrototype {
  public:
    TParaFormatterObject(void);
    virtual ~TParaFormatterObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Put = TParaObjectPrototype::_NumberOfMethods,
	MethodId_Flush,
	MethodId_SetWidth,
	MethodId_SetPrecision,
	MethodId_SetFill,
	MethodId_SetBase,
	MethodId_Hex,
	MethodId_Dec,
	_NumberOfMethods
    };
  protected:
    int Put(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Flush(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetWidth(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetPrecision(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetFill(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetBase(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Hex(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Dec(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  private:
    std::ostrstream* _FormatStream;
};


class TParaScannerObject: public TParaObjectPrototype {
  public:
    TParaScannerObject(void);
    virtual ~TParaScannerObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Load = TParaObjectPrototype::_NumberOfMethods,
	MethodId_Get,
	MethodId_SetBase,
	MethodId_IsGood,
	MethodId_LastGetCount,
	_NumberOfMethods
    };
  protected:
    int Load(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int Get(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int SetBase(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int IsGood(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    int LastGetCount(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  private:
    char* _Source;
    std::istrstream* _SourceStream;
};


class TParaArgumentObject: public TParaObjectPrototype {
  public:
    TParaArgumentObject(int argc, char** argv);
    virtual ~TParaArgumentObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual void Parse(void);
  protected:
    enum {
	MethodId_NumberOfArguments = TParaObjectPrototype::_NumberOfMethods,
	MethodId_GetArgumentOf,
	MethodId_NumberOfParameters,
	MethodId_GetParameterOf,
	MethodId_IsOptionSpecified,
	MethodId_GetOptionValueOf,
	_NumberOfMethods
    };
  protected:
    int NumberOfArguments(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetArgumentOf(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int NumberOfParameters(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetParameterOf(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int IsOptionSpecified(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int GetOptionValueOf(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
  private:
    int _argc;
    char** _argv;
    bool _IsParsed;
    std::vector<std::string> _ArgumentList;
    std::vector<std::string> _ParameterList;
    std::map<std::string, std::string> _OptionTable;
};


class TParaSystemObject: public TParaObjectPrototype {
  public:
    TParaSystemObject(void);
    virtual ~TParaSystemObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    int System(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    int Shell(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
  protected:
    enum {
	MethodId_System = TParaObjectPrototype::_NumberOfMethods,
	MethodId_Shell,
	_NumberOfMethods
    };
};




#endif
