/* RoomDefs.cc */
/* Created by Enomoto Sanshiro on 18 November 1997. */
/* Last updated by Enomoto Sanshiro on 18 Febuary 1998. */


#include <iostream>
#include <string>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include "RoomDefs.hh"

using namespace std;


THardwareException::THardwareException(string Location, string Message) 
{
    _Message = Location + string(": ") + Message;
}

THardwareException::THardwareException(const THardwareException &e) 
{
    _Message = e._Message;
}    

string THardwareException::Message(void) const
{
    return _Message;
}

ostream& operator<< (ostream &os, const THardwareException &e) 
{
    return os << e._Message;
}

static void AlarmSignalHandler(int SignalNumber) {}
void Suspend(unsigned long Time_sec, unsigned long Time_usec)
{
    static struct itimerval IntervalTimerValue;
    IntervalTimerValue.it_value.tv_sec = Time_sec + (Time_usec / 1000000UL);
    IntervalTimerValue.it_value.tv_usec = Time_usec % 1000000UL;
    IntervalTimerValue.it_interval.tv_sec = 0;
    IntervalTimerValue.it_interval.tv_usec = 0;

    static sigset_t AllSignalSet;
    sigfillset(&AllSignalSet);

    static struct sigaction SignalAction;
    SignalAction.sa_handler = AlarmSignalHandler;
    SignalAction.sa_mask = AllSignalSet;
    SignalAction.sa_flags = 0;
    sigaction(SIGALRM, &SignalAction, 0);

    static sigset_t OldSignalSet;
    sigprocmask(SIG_BLOCK, &AllSignalSet, &OldSignalSet);
    setitimer(ITIMER_REAL, &IntervalTimerValue, 0);
    sigsuspend(&OldSignalSet);
    sigprocmask(SIG_SETMASK, &OldSignalSet, 0);

    return;
}
