/* RoomDefs.hh */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 1 February 2000. */


#ifndef __RoomDefs_hh__
#define __RoomDefs_hh__


#include <iostream>
#include <string>
#include "RoomConfig.hh"


typedef U8bit Byte;
typedef U16bit Word;
typedef U32bit DoubleWord;

#define Bit(n) (0x00000001UL << (n))
// LSB is bit 0 (not 1)


class THardwareException {
  protected:
    std::string _Message;
  public:
    THardwareException(std::string Location, std::string Message);
    THardwareException(const THardwareException &e);
    std::string Message(void) const;
    friend std::ostream& operator<< (std::ostream &os, const THardwareException &e);
};


void Suspend(unsigned long Time_sec, unsigned long Time_usec);

#endif
