/* RoomDeviceFactory.hh */
/* Created by Enomoto Sanshiro on 7 May 1999. */
/* Last updated by Enomoto Sanshiro on 7 July 2001. */


#ifndef __RoomDeviceFactory_hh__
#define __RoomDeviceFactory_hh__


#include <string>
#include <map>
#include "RoomDefs.hh"
#include "RoomDeviceBase.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "RoomCamacAccess.hh"
#include "RoomVmeBridge.hh"
#include "RoomSoftwareDevice.hh"


class TRoomDeviceFactory {
  public:
    static TRoomDeviceFactory* GetInstance(void);
    virtual ~TRoomDeviceFactory();
    virtual void RegisterVmeController(const std::string& Name, TRoomVmeController* Controller);
    virtual void RegisterCamacController(const std::string& Name, TRoomCamacController* Controller);
    virtual void RegisterVmeCamacBridge(const std::string& Name, TRoomVmeCamacBridge* Bridge);
    virtual void RegisterVmeModule(const std::string& Name, TRoomVmeModule* Module);
    virtual void RegisterCamacModule(const std::string& Name, TRoomCamacModule* Module);
    virtual void RegisterSoftwareModule(const std::string& Name, TRoomSoftwareModule* Module);
    virtual TRoomVmeModule* CreateVmeModule(const std::string& Name) throw(THardwareException);
    virtual TRoomCamacModule* CreateCamacModule(const std::string& Name) throw(THardwareException);
    virtual TRoomSoftwareModule* CreateSoftwareModule(const std::string& Name) throw(THardwareException);
    virtual TRoomVmeCrate* CreateVmeCrate(const std::string& Name = "") throw(THardwareException);
    virtual TRoomCamacCrate* CreateCamacCrate(const std::string& Name = "") throw(THardwareException);
    virtual TRoomVmeController* CreateVmeController(const std::string& Name = "") throw(THardwareException);
    virtual TRoomCamacController* CreateCamacController(const std::string& Name = "") throw(THardwareException);
    virtual TRoomVmeCamacBridge* CreateVmeCamacBridge(const std::string& Name = "") throw(THardwareException);
    virtual void ShowDeviceList(std::ostream& os) const;
  protected:
    TRoomDeviceFactory(void);
    std::string ReducedNameOf(std::string Name) const;
  protected:
    static TRoomDeviceFactory* _Instance;
    std::map<std::string, TRoomVmeController*> _VmeControllerTable;
    std::map<std::string, TRoomCamacController*> _CamacControllerTable;
    std::map<std::string, TRoomVmeCamacBridge*> _VmeCamacBridgeTable;
    std::map<std::string, TRoomVmeModule*> _VmeModuleTable;
    std::map<std::string, TRoomCamacModule*> _CamacModuleTable;
    std::map<std::string, TRoomSoftwareModule*> _SoftwareModuleTable;
};



class TRoomVmeControllerCreator {
  public:
    TRoomVmeControllerCreator(const std::string& Name, TRoomVmeController* Controller);
};

class TRoomCamacControllerCreator {
  public:
    TRoomCamacControllerCreator(const std::string& Name, TRoomCamacController* Controller);
};

class TRoomVmeCamacBridgeCreator {
  public:
    TRoomVmeCamacBridgeCreator(const std::string& Name, TRoomVmeCamacBridge* Bridge);
};

class TRoomVmeModuleCreator {
  public:
    TRoomVmeModuleCreator(const std::string& Name, TRoomVmeModule* Module);
};

class TRoomCamacModuleCreator {
  public:
    TRoomCamacModuleCreator(const std::string& Name, TRoomCamacModule* Module);
};

class TRoomSoftwareModuleCreator {
  public:
    TRoomSoftwareModuleCreator(const std::string& Name, TRoomSoftwareModule* Module);
};


#endif
