/* RoomModule.cc */
/* Created by Enomoto Sanshiro on 10 July 1998. */
/* Last updated by Enomoto Sanshiro on 7 July 2001. */


#include <iostream>
#include <string>
#include "RoomModule.hh"

using namespace std;


TRoomModule::TRoomModule(const string& ModuleType, const string& ModelName)
{
    _ModuleType = ModuleType;
    _ModelName = ModelName;
}

TRoomModule::~TRoomModule()
{
}

void TRoomModule::Destroy(void)
{
}

void TRoomModule::SetModuleName(const string& ModuleName)
{
    _ModuleName = ModuleName;
}

string TRoomModule::ModuleName(void)
{
    return _ModuleName;
}

string TRoomModule::ModelName(void)
{
    return _ModuleType + " (" + _ModelName + ")";
}

bool TRoomModule::Probe(void) throw(THardwareException)
{
    return true;
}

int TRoomModule::Initialize(int InitialState) throw(THardwareException)
{
    return 0;
}

int TRoomModule::Finalize(int FinalState) throw(THardwareException)
{
    return 0;
}

int TRoomModule::Enable(int Address) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::Enable()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::Disable(int Address) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::Disable()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::IsEnabled(int Address) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::IsEnabled()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::IsBusy(int Address) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::IsBusy()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::Clear(int Address) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::Clear()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::Read(int Address, int &Data)  throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::Read()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::Write(int Address, int Data)  throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::Write()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::SequentialRead(int Address, int Data[], int MaxSize) throw(THardwareException)
{
    int DataCount = 0;

    while ((DataCount < MaxSize) && (Read(Address, Data[DataCount]) > 0)) {
	DataCount++;
    }

    return DataCount;
}

int TRoomModule::SequentialWrite(int Address, int Data[], int Size) throw(THardwareException)
{
    int DataCount = 0;

    while ((DataCount < Size) && (Write(Address, Data[DataCount]) > 0)) {
	DataCount++;
    }

    return DataCount;
}

int TRoomModule::NextNumberOfDataElements(int Address) throw(THardwareException)
{
    return 1;
}

int TRoomModule::BlockRead(int Address, void *Data, int MaxSize)  throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::BlockRead()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::BlockWrite(int Address, const void *Data, int Size)  throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::BlockWrite()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::NextDataBlockSize(int Address) throw(THardwareException)
{
    // If the next data block size cannot be expected,
    // return the maximun possible data block size.

    throw THardwareException(
        "TRoomModule::NextDataBlockSize()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::NumberOfChannels(void) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::NumberOfChannels()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::AddressBitLength(void)
{
    return 32;
}

int TRoomModule::DataBitLength(void)
{
    return 32;
}

int TRoomModule::EnableInterrupt(int SignalId) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::EnableInterrupt()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::DisableInterrupt(void) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::DisableInterrupt()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::ClearInterrupt(void) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::ClearInterrupt()", 
	"function is not available for module: " + ModelName()
    );

    return 0;
}

int TRoomModule::ReadRegister(int Address, int& Data) throw(THardwareException)
{
    return Read(Address, Data);
}

int TRoomModule::WriteRegister(int Address, int Data) throw(THardwareException)
{
    return Write(Address, Data);
}

bool TRoomModule::HasData(int Address) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::HasData()", 
	"function is not available for module: " + ModelName()
    );

    return false;
}

bool TRoomModule::WaitData(unsigned TimeOut_sec) throw(THardwareException)
{
    unsigned Time_msec = 0;
    bool EventOccured;

    while (1) {
	EventOccured = HasData();
	if ((EventOccured) || (Time_msec * 1000 > TimeOut_sec)) {
	    break;
	}
	
	if (TimeOut_sec > 0) {
	    Time_msec++;
	}
	Suspend(0, 1000);
    }

    return EventOccured;
}

int TRoomModule::MiscControlIdOf(const string& CommandName) throw (THardwareException)
{
    throw THardwareException(
        "TRoomModule::MiscControlIdOf()", 
	"invalid command: " + ModelName() + "::" + CommandName
    );

    return 0;
}

int TRoomModule::MiscControl(int ControlId, int* ArgumentList, int NumberOfArguments) throw (THardwareException)
{
    throw THardwareException(
        "TRoomModule::MiscControl()", 
	"invalid command id: " + ModelName()
    );

    return 0;
}

bool TRoomModule::WaitForServiceRequest(int TimeOut_sec) throw(THardwareException)
{
    return WaitData(TimeOut_sec);
}

bool TRoomModule::IsRequestingService(void) throw(THardwareException)
{
    return HasData();
}

void TRoomModule::ClearServiceRequest(void) throw(THardwareException)
{
    throw THardwareException(
        "TRoomModule::ClearServiceRequest()", 
	"function is not available for module: " + ModelName()
    );
}
