/* RoomModule.hh */
/* Created by Enomoto Sanshiro on 10 July 1998. */
/* Last updated by Enomoto Sanshiro on 7 July 2001. */


#ifndef __RoomModule_hh__
#define __RoomModule_hh__


#include <string>
#include "RoomDefs.hh"
#include "RoomServiceRequester.hh"


class TRoomModule: public TRoomServiceRequester {
  protected:
    TRoomModule(const std::string& ModuleType, const std::string& ModelName);
  public:
    virtual ~TRoomModule();
    virtual void Destroy(void);
    virtual void SetModuleName(const std::string& ModuleName);
    virtual std::string ModelName(void);
    virtual std::string ModuleName(void);

    // Module Control //
    virtual bool Probe(void) throw(THardwareException);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int IsEnabled(int Address = -1) throw(THardwareException);
    virtual int IsBusy(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);

    // I/O Actions //
    /* single I/O actions */
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int Write(int Address, int Data) throw(THardwareException);
    /* sequential I/O actions */
    virtual int SequentialRead(int Address, int Data[], int MaxSize) throw(THardwareException);
    virtual int SequentialWrite(int Address, int Data[], int Size) throw(THardwareException);
    virtual int NextNumberOfDataElements(int Address = -1) throw(THardwareException);
    /* block I/O actions */
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int BlockWrite(int Address, const void *Data, int Size) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);

    // Introspection //
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);

    // Interrupt Handling //
    virtual int EnableInterrupt(int SignalId = 0) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);

    // Other Controls //
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);

    // Misc Controls //
    virtual int MiscControlIdOf(const std::string& CommandName) throw(THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);

    // Service Request //
    virtual bool WaitForServiceRequest(int TimeOut_sec = 1) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  protected:
    std::string _ModuleType;
    std::string _ModelName;
    std::string _ModuleName;
};


#endif
