/* bridge-Kinetic_2917.hh */
/* Created by Enomoto Sanshiro on 5 July 2003. */
/* Last updated by Enomoto Sanshiro on 5 July 2003. */


#ifndef __brigde_Kinetic_2917_hh__
#define __bridge_Kinetic_2917_hh__


#include "RoomVmeBridge.hh" 


class TVmeCamacBridge_Kinetic_2917: public TRoomVmeCamacBridge {
  public:
    TVmeCamacBridge_Kinetic_2917(void);
    virtual ~TVmeCamacBridge_Kinetic_2917();
    virtual TRoomVmeCamacBridge* CloneBridge(void);
  public:
    // Camac Controller Interface //
    virtual void Open(void) throw(THardwareException);
    virtual void Close(void);
    virtual int Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException);
    virtual int Initialize(void) throw(THardwareException);
    virtual int Clear(void) throw(THardwareException);
    virtual int SetInhibition(void) throw(THardwareException);
    virtual int ReleaseInhibition(void) throw(THardwareException);
    virtual int EnableInterruptNotification(void) throw(THardwareException);
    virtual int DisableInterruptNotification(void) throw(THardwareException);
    virtual int ReadLam(int LamMask) throw(THardwareException);
    virtual int WaitLam(int TimeOut_sec) throw(THardwareException);
  public:
    // Vme Module Interface //
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int SequentialRead(int Address, int Data[], int MaxSize) throw(THardwareException);
    virtual int NextNumberOfDataElements(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int EnableInterrupt(int SignalId = 0) throw(THardwareException);
    virtual int DisableInterrupt(void) throw(THardwareException);
    virtual int ClearInterrupt(void) throw(THardwareException);
    virtual void EnableServiceRequest(void) throw(THardwareException);
    virtual void DisableServiceRequest(void) throw(THardwareException);
    virtual void ClearServiceRequest(void) throw(THardwareException);
    virtual bool WaitForServiceRequest(int TimeOut_sec) throw(THardwareException);
    virtual bool IsRequestingService(void) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
  public:
    void SetCrateNumber(int CrateNumber);
    void SetBufferSize(int BufferSize);
    void SetCommandMemoryAddress(int Address);
    void LoadCommand(int Command);
    int ExecuteSingleTransfer(int Crate, int Station, int Function, int Address, int& Data, int& Q, int&X) throw(THardwareException);
    int ExecuteReadList(U32bit* Data, int MaxSize) throw (THardwareException);
  protected:
    U32bit* _Buffer;
    int _BufferSize;
    int _NumberOfDataWords, _DataWordCounts;
    int _CrateNumber;
    bool _IsInterruptInstalled;
  public:
    enum TControlId {
	ControlId_SetBufferSize,
	ControlId_SetCommandMemoryAddress,
	ControlId_ExecuteSingleTransfer,
	ControlId_LoadCommand,
	ControlId_LoadSingleTransferCommand,
	ControlId_LoadInlineWriteCommand,
	ControlId_LoadQStopBlockTransferCommand,
	ControlId_LoadQIgnoreBlockTransferCommand,
	ControlId_LoadQRepeatBlockTransferCommand,
	ControlId_LoadQScanBlockTransferCommand,
	ControlId_LoadJumpCommand,
	ControlId_LoadHaltCommand,
	_NumberOfControls
    };
    enum TRegisters {
	regCSE = 0x00,         // Channel Status/Error
	regDOC = 0x04,         // Device/Operation Control
	regSCC = 0x06,         // Sequence/Channel Control
	regMTC = 0x0a,         // Memory Transfer Count
	regMACHI = 0x0c,       // Memory Address Counter High
	regMACLO = 0x0e,       // Memory Address Counter Low
	regINTLam = 0x40,      // LAM Interrupt Control
	regINTDone = 0x42,     // Done Interrupt Control
	regINTEmpty = 0x44,    // DMA Buffer Empty Interrupt Control
	regINTAbort = 0x46,    // List Abort Interrupt Control
            bitINT_Flag = (0x0001 << 7),
	    bitINT_FlagAutoClear = (0x0001 << 6),
	    bitINT_IntEnable = (0x0001 << 4),
	    bitINT_IntAutoClear = (0x0001 << 3),
	regVECLam = 0x48,      // LAM Interrupt Vector
	regVECDone = 0x4a,     // Done Interrupt Vector
	regVECEmpty = 0x4c,    // DMA Buffer Empty Interrupt Vector
	regVECAbort = 0x4e,    // List Abort Interrupt Vector
	regAMR = 0x60,         // Address Modifier Register
	regCMR = 0x62,         // Command Memory Register
            bitCMR_Single = (0x00 << 5),
            bitCMR_Block = (0x01 << 5),
            bitCMR_InlineWrite = (0x11 << 5),
            bitCMR_QStop = (0x00 << 3),
            bitCMR_QIgnore = (0x01 << 3),
            bitCMR_QRepeat = (0x02 << 3),
            bitCMR_QScan = (0x03 << 3),
            bitCMR_24bit = (0x00 << 1),
            bitCMR_16bit = (0x01 << 1),
            bitCMR_AD = (0x0001 << 0),
            bitCMR_Jump = 0x00c0,
            bitCMR_Halt = 0x0080,
	regCMA = 0x64,         // Command Memory Address
	regCWC = 0x66,         // Command Word Count
	regSRR = 0x68,         // Service Request
	regDLR = 0x6a,         // Data Low Register
	regDHR = 0x6c,         // Data High Register
	regCSR = 0x6e,         // Control Status Register
            bitCSR_GO = (0x0001 << 0),
	    bitCSR_NOQ = (0x0001 << 1),
	    bitCSR_NOX = (0x0001 << 2),
	    bitCSR_DIR = (0x0001 << 5),
	    bitCSR_DONE = (0x0001 << 7),
	    bitCSR_RDY = (0x0001 << 8),
	    bitCSR_LAM = (0x0001 << 9),
	    bitCSR_RST = (0x0001 << 12),
	    bitCSR_TMO = (0x0001 << 13),
	    bitCSR_ABT = (0x0001 << 14),
	    bitCSR_ERR = (0x0001 << 15),
	_NumberOfRegisters
    };
};


#endif
