/* controller-Force_FGA5x00.cc */
/* Created by Enomoto Sanshiro on 6 October 1997. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */


#include <cerrno>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>

#include <sys/vme_types.h>
#include <sys/vme.h>
#include "vui.hh"
#include "RoomDeviceFactory.hh"
#include "controller-Force_FGA5x00.hh"

using namespace std;


static TRoomVmeControllerCreator Creator(
    "FORCE_FGA5x00", new TVmeController_Force_FGA5x00()
);


static const char *VmeplusDeviceFileName[] = {
    /* this must be consistent with TRoomVmeTarnsferMode */
    /* (declared in RoomVmeAccess.hh) */
    "/dev/vme16d16", "/dev/vme16d32",
    "/dev/vme24d16", "/dev/vme24d32", 
    "/dev/vme32d16", "/dev/vme32d32"
};

static const char *VmedmaDeviceFileName[] = {
    /* this must be consistent with TRoomVmeTarnsferMode */
    /* (declared in RoomVmeAccess.hh) */
    "/dev/vmedma16d16", "/dev/vmedma16d32",
    "/dev/vmedma24d16", "/dev/vmedma24d32", 
    "/dev/vmedma32d16", "/dev/vmedma32d32"
};


TVmeController_Force_FGA5x00::TVmeController_Force_FGA5x00(void)
{
}

TVmeController_Force_FGA5x00::~TVmeController_Force_FGA5x00()
{
}

TRoomVmeController* TVmeController_Force_FGA5x00::CloneController(void)
{
    return new TVmeController_Force_FGA5x00();
}

const char* TVmeController_Force_FGA5x00::DeviceFileName(TRoomVmeTransferMode TransferMode)
{
    return VmeplusDeviceFileName[TransferMode];
}

const char* TVmeController_Force_FGA5x00::DmaDeviceFileName(TRoomVmeTransferMode TransferMode)
{
    return VmedmaDeviceFileName[TransferMode];
}

void TVmeController_Force_FGA5x00::RegisterInterruptNotification(TRoomVmeAccessProperty* Property, int SignalId) throw(THardwareException)
{
    Property->InterruptSignalId = SignalId;
}

void TVmeController_Force_FGA5x00::UnregisterInterruptNotification(TRoomVmeAccessProperty* Property) throw(THardwareException)
{
    TRoomVmeController::UnregisterInterruptNotification(Property);
}

void TVmeController_Force_FGA5x00::EnableInterruptNotification(TRoomVmeAccessProperty* Property) throw(THardwareException)
{
    int DeviceDescriptor = Property->DeviceDescriptor;
    ioctl_irq_t InterruptDefinition;
    InterruptDefinition.prop = Property->InterruptNumber;
    InterruptDefinition.sig = Property->InterruptSignalId;
  
    if (vui_intr_ena(DeviceDescriptor, &InterruptDefinition) != VUI_OK) {
	throw THardwareException(
	    "TVmeModule::EnableInterrupt(): ",
	    "failure to enable interrupt:\n"
	    "  1) Make sure that other process[es] does not use the same interrupt.\n"
	    "  2) Check the interrupt property settings in '/kernel/drv/vmeplus.conf'.".
        );
    }
}

void TVmeController_Force_FGA5x00::DisableInterruptNotification(TRoomVmeAccessProperty* Property) throw(THardwareException)
{
    int DeviceDescriptor = Property->DeviceDescriptor;
    ioctl_irq_t InterruptDefinition;
    InterruptDefinition.prop = Property->InterruptNumber;
    InterruptDefinition.sig = Property->InterruptSignalId;
  
    if (vui_intr_dis(DeviceDescriptor, &InterruptDefinition) != VUI_OK) {
	throw THardwareException(
	    "TVmeModule::DisableInterrupt(): ",
	    "failure to disable interrupt."
        );
    }
}

////////////////////////////////////////////////////////////////
//
// The following WaitForInterruptNotification is a horrible kludge
// which can't handle more than one interrupt source, and can't even
// tell for sure if it was really a VME device that caused the event
// it wakes up on (SIGPOLL)  -GAHS
//
static int Signalled=0;
static void DumbSignalHandler(int) 
{
    Signalled++;
}

bool TVmeController_Force_FGA5x00::WaitForInterruptNotification(TRoomVmeAccessProperty* Property, unsigned TimeOut) throw(THardwareException)
{
    void (*OldSignalHandler)(int);
    OldSignalHandler = signal(SIGPOLL, DumbSignalHandler);

    int OldSignalId = Property->InterruptSignalId;    
    Property->InterruptSignalId = SIGPOLL;

    EnableInterruptNotification(Property);
    while (Signalled == 0) {
	TimeOut = sleep(TimeOut);
    }
    DisableInterruptNotification(Property);

    signal(SIGPOLL, OldSignalHandler);
    Property->InterruptSignalId = OldSignalId;
    Signalled = 0;
    
    return (TimeOut > 0);
}
//
// End of horrible kludge
//
////////////////////////////////////////////////////////////////
