/* Kek_Camlib.cc */
/* Created by Enomoto Sanshiro on 6 October 1997. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */


// ***************************************** //
//  THIS CODE IS NOT MAINTAINED. DO NOT USE. //
// ***************************************** //


#include <camlib.h>
#include "RoomDeviceFactory.hh"
#include "controller-Kek_Camlib.hh"

using namespace std;


static TRoomCamacControllerCreator Creator(
    "KEK_Camlib", new TCamacController_Kek_Camlib()
);


/* camlib definitions <camlib.h> */
extern "C" { 
    int CAMOPN(void);
    int CAMCLS(void);
    int CSETBR(int /* (?o?) */);
    int CSETCR(int crate);
    int CGENZ(void);
    int CGENC(void);
    int CREMI(void);
    int CSETI(void);
    int CAMACW(int naf, short *dat, int *q, int *x);
    int CAMAC(int naf, int *dat, int *q, int *x);
    int CELAM(int mask);
    int CDLAM(void);
    int CWLAM(int timeout);
    int CDMAW(int mode, int naf, unsigned short *buf, int len, int *retlen, int *err);
    int CDMAL(int mode, int naf, int *buf, int len, int *retlen, int *err);
    int CLEWAI(unsigned short *list, int lenlis, unsigned short *buf, int lenbuf, struct cc_iosb *iosb);
    int CEWAI(unsigned short *buf, int lenbuf, struct cc_iosb *iosb);
    int CLLOA(unsigned short *list, int lenlis, int *err);
    int CRLIST(char *fname, unsigned short *list, int lenlis, int *retlen, int *err);
}


TCamacController_Kek_Camlib::TCamacController_Kek_Camlib(void)
{
    _IsOpened = 0;
    _IsInterruptNotificationEnabled = 0;
}

TCamacController_Kek_Camlib::~TCamacController_Kek_Camlib()
{
    Close();
}

TRoomCamacController* TCamacController_Kek_Camlib::CloneController(void)
{
    return new TCamacController_Kek_Camlib();
}

void TCamacController_Kek_Camlib::Open(void) throw(THardwareException)
{
    if (_IsOpened) {
	return;
    }

    int Status = 0;

    Status += CAM_Open();
    Status += CSETBR(1);
    Status += CSETCR(0);

    Status += CGENC();
    Status += CGENZ();
    Status += CREMI();

    if (Status != 0) {
	throw THardwareException(
            "TCamacController_Kek_Camlib::Open()",
            "Initialization fault"
        );
    }

    _IsOpened = 1;
}

void TCamacController_Kek_Camlib::Close(void)
{
    if (_IsInterruptNotificationEnabled) {
	try {
	    DisableInterruptNotification();
	}
	catch (THardwareException &e) {
	}
    }

    if (_IsOpened) {
	CAM_Close();
	_IsOpened = 0;
    }
}

int TCamacController_Kek_Camlib::EnableInterruptNotification(void) throw(THardwareException)
{
    if (_IsInterruptNotificationEnabled) {
	return 0;
    }

    unsigned LamMask = ~0;
    int Status = CAM_EnableLAM(LamMask);
    if (Status != 0) {
	throw THardwareException(
            "TCamacController_Kek_Camlib::EnableLam()",
            "LAM enable fault"
        );
    }

    _IsInterruptNotificationEnabled = 1;

    return Status;
}

int TCamacController_Kek_Camlib::DisableInterruptNotification(void) throw(THardwareException)
{
    if (! _IsInterruptNotificationEnabled) {
	return 0;
    }

    int Status = CAM_DisableLAM();

    if (Status != 0) {
	throw THardwareException(
            "TCamacController_Kek_Camlib::DisableLam()",
            "LAM disable fault"
        );
    }

    return Status;
}

int TCamacController_Kek_Camlib::ReadLam(int LamMask) throw(THardwareException)
{
    int LamPattern = 0;

    int StationBit, Data, Q, X;
    for (int Station = 1; StationBit < 24; Station++) {
	StationBit = Bit(Station);
	if (StationBit & LamMask) {
	    Transact(StationNumber, fnTestLam, adAny, Data, Q, X);
	    if (Q) {
		LamPettern |= StationBit;
	    }
	}
    }

    return LamPattern;
}

int TCamacController_Kek_Camlib::WaitLam(int TimeOut) throw(THardwareException)
{
    if (! _IsInterruptNotificationEnabled) {
	EnableInterruptNotification();
    }

    return CAM_WaitLAM(TimeOut);
}

int TCamacController_Kek_Camlib::Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException)
{
    static int Result;
    Result = CAMAC(NAF(StationNumber, Address, Function), &Data, &Q, &X);
    Data &= 0x00FFFFFF;

    return Result;
}

int TCamacController_Kek_Camlib::Initialize(void) throw(THardwareException)
{
   return CGENZ(); 
}

int TCamacController_Kek_Camlib::Clear(void) throw(THardwareException)
{
    return CGENC();
}

int TCamacController_Kek_Camlib::SetInhibition(void) throw(THardwareException)
{
    return CSETI();
}

int TCamacController_Kek_Camlib::ReleaseInhibition(void) throw(THardwareException)
{
    return CREMI();
}

