/* controller-Kinoko_Camdrv.cc */
/* Created by Enomoto Sanshiro on 13 April 1999. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */


#include <cerrno>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include "camdrv.h"
#include "RoomDeviceFactory.hh"
#include "controller-Kinoko_Camdrv.hh"

using namespace std;


static TRoomCamacControllerCreator Creator1(
    "Kinoko_Camdrv", new TCamacController_Kinoko_Camdrv()
);
static TRoomCamacControllerCreator Creator2(
    "Toyo_CC7x00", new TCamacController_Kinoko_Camdrv()
);
static TRoomCamacControllerCreator Creator3(
    "Hoshin_CCP", new TCamacController_Kinoko_Camdrv()
);


#define NAF(n, a, f) ((((n) << 9) | ((a) << 5) | (f)) & 0x00003fff)

TCamacController_Kinoko_Camdrv::TCamacController_Kinoko_Camdrv(void)
{
    _Device = -1;
}

TCamacController_Kinoko_Camdrv::~TCamacController_Kinoko_Camdrv()
{
    Close();
}

TRoomCamacController* TCamacController_Kinoko_Camdrv::CloneController(void)
{
    return new TCamacController_Kinoko_Camdrv();
}

void TCamacController_Kinoko_Camdrv::Open(void) throw(THardwareException)
{
    if (_Device > 0) {
	return;
    }

    const char* DeviceFile = "/dev/camdrv";
    _Device = open(DeviceFile, O_RDWR);
    if (_Device < 0) {
	throw THardwareException(
	    "TCamacController_Kinoko_Camdrv::Open(): open(2)",
	    strerror(errno)
	);
    }
}

void TCamacController_Kinoko_Camdrv::Close(void)
{
    DisableInterruptNotification();

    if (_Device > 0) {
        close(_Device);
    }
}

int TCamacController_Kinoko_Camdrv::Transact(int StationNumber, int Function, int Address, int &Data, int &Q, int &X) throw(THardwareException)
{
    static unsigned IoctlData[2];

    IoctlData[0] = NAF(StationNumber, Address, Function);
    IoctlData[1] = (unsigned) Data;

    int Result = ioctl(_Device, CAMDRV_IOC_CAMAC_ACTION, IoctlData);
    if (Result < 0) {
	throw THardwareException(
	   "TCamacController_Kinoko_Camdrv::Transact(): ioctl(2)", 
           strerror(errno)
        );
    }
        
    Data = IoctlData[1] & 0x00ffffff;
    X = ! (Result & 0x0002);
    Q = ! (Result & 0x0001);

    return Result;
}

int TCamacController_Kinoko_Camdrv::Initialize(void) throw(THardwareException)
{
    int Result = ioctl(_Device, CAMDRV_IOC_INITIALIZE, 0);
    return Result;
}

int TCamacController_Kinoko_Camdrv::Clear(void) throw(THardwareException)
{
    int Result = ioctl(_Device, CAMDRV_IOC_CLEAR, 0);
    return Result;
}

int TCamacController_Kinoko_Camdrv::SetInhibition(void) throw(THardwareException)
{
    int Result = ioctl(_Device, CAMDRV_IOC_INHIBIT, 0);    
    return Result;
}

int TCamacController_Kinoko_Camdrv::ReleaseInhibition(void) throw(THardwareException)
{
    int Result = ioctl(_Device, CAMDRV_IOC_RELEASE_INHIBIT, 0);
    return Result;
}

int TCamacController_Kinoko_Camdrv::EnableInterruptNotification(void) throw(THardwareException)
{
    int Result = ioctl(_Device, CAMDRV_IOC_ENABLE_INTERRUPT, 0);

    return Result;
}

int TCamacController_Kinoko_Camdrv::DisableInterruptNotification(void) throw(THardwareException)
{
    int Result = ioctl(_Device, CAMDRV_IOC_DISABLE_INTERRUPT, 0);

    return Result;
}

int TCamacController_Kinoko_Camdrv::ReadLam(int LamMask) throw(THardwareException)
{
    static unsigned IoctlData[2];
    IoctlData[0] = 0;
    IoctlData[1] = 0;

    int Result = ioctl(_Device, CAMDRV_IOC_READ_LAM, IoctlData);
    if (Result < 0) {
	throw THardwareException(
           "TCamacController_Kinoko_Camdrv::ReadLam(): ioctl(2)",
           strerror(errno)
        );
    }

    int LamPattern = IoctlData[1];

    return LamPattern & LamMask;
}

int TCamacController_Kinoko_Camdrv::WaitLam(int TimeOut_sec) throw(THardwareException)
{
    EnableInterruptNotification();

    static unsigned IoctlData[2];
    IoctlData[0] = TimeOut_sec;
    IoctlData[1] = 0;

    int LamBits = ioctl(_Device, CAMDRV_IOC_WAIT_LAM, IoctlData);

    return LamBits;
}
