/* controller-Kinoko_Vmedrv.hh */
/* Created by Enomoto Sanshiro on 11 December 1999. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */


#ifndef __controller_Kinoko_Vmedrv_hh__
#define __controller_Kinoko_Vmedrv_hh__


#include "RoomVmeAccess.hh"


class TVmeController_Kinoko_Vmedrv: public TRoomVmeController {
  public:
    TVmeController_Kinoko_Vmedrv(void);
    virtual ~TVmeController_Kinoko_Vmedrv();
    virtual TRoomVmeController* CloneController(void);
  public:
    virtual TRoomVmeAccessProperty* Open(TRoomVmeTransferMode TransferMode) throw(THardwareException);
    virtual void Close(TRoomVmeAccessProperty* Property);
    virtual caddr_t Map(TRoomVmeAccessProperty* Property, off_t VmeAddress, size_t MapSize, off_t MapOffset) throw(THardwareException);
    virtual void Unmap(TRoomVmeAccessProperty* Property) throw(THardwareException);
    virtual void RegisterInterruptNotification(TRoomVmeAccessProperty* Property, int SignalId = 0) throw(THardwareException);
    virtual void UnregisterInterruptNotification(TRoomVmeAccessProperty* Property) throw(THardwareException);
    virtual void EnableInterruptNotification(TRoomVmeAccessProperty* Property) throw(THardwareException);
    virtual void DisableInterruptNotification(TRoomVmeAccessProperty* Property) throw(THardwareException);
    virtual bool WaitForInterruptNotification(TRoomVmeAccessProperty* Property, unsigned TimeOut) throw(THardwareException);
  public:
    virtual bool IsSignalOnInterruptAvailable(void);
  protected:
    virtual const char* DeviceFileName(TRoomVmeTransferMode TransferMode);
    virtual const char* DmaDeviceFileName(TRoomVmeTransferMode TransferMode);
  private:
    int _InterruptEnableCount;
};

#endif
