/* module-CamacModules.cc */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 29 December 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomCamacAccess.hh"
#include "module-CamacModules.hh"

using namespace std;


static TRoomCamacModuleCreator Creator1(
    "Generic_Standard", new TStandardCamacModule()
);
static TRoomCamacModuleCreator Creator2(
    "Rinei_RPC022", new TCamacQADC_Rinei_RPC022()
);
static TRoomCamacModuleCreator Creator3(
    "Hoshin_C009", new TCamacQADC_Hoshin_C009()
);
static TRoomCamacModuleCreator Creator4(
    "Rinei_RPC060", new TCamacTDC_Rinei_RPC060()
);
static TRoomCamacModuleCreator Creator5(
    "Rinei_RPC130", new TCamacTDC_Rinei_RPC130()
);
static TRoomCamacModuleCreator Creator6(
    "Rinei_RPC140", new TCamacTDC_Rinei_RPC140()
);
static TRoomCamacModuleCreator Creator7(
    "Hoshin_C006", new TCamacTDC_Hoshin_C006()
);
static TRoomCamacModuleCreator Creator8(
    "Rinei_RPC081", new TCamacFADC_Rinei_RPC081()
);
static TRoomCamacModuleCreator Creator9(
    "Rinei_RPC250", new TCamacFADC_Rinei_RPC250()
);
static TRoomCamacModuleCreator Creator10(
    "Kaizu_KC3471", new TCamacOutputRegister_Kaizu_KC3471()
);



TStandardCamacModule::TStandardCamacModule(void)
: TRoomCamacModule("CamacModule", "Generic_CamacModule")
{
}

TStandardCamacModule::~TStandardCamacModule()
{
}

TRoomCamacModule* TStandardCamacModule::Clone(void)
{
    return new TStandardCamacModule();
}




TCommonplaceCamacModule::TCommonplaceCamacModule(const string& ModuleType, const string& ModelName, TCamacProperties& CamacProperties)
: TRoomCamacModule(ModuleType, ModelName), _CamacProperties(CamacProperties)
{
}

TCommonplaceCamacModule::TCommonplaceCamacModule(const string& ModuleType, const string& ModelName)
: TRoomCamacModule(ModuleType, ModelName)
{
}

TCommonplaceCamacModule::~TCommonplaceCamacModule() 
{
}

TRoomCamacModule* TCommonplaceCamacModule::Clone(void)
{
    return new TCommonplaceCamacModule(
	_ModuleType, _ModelName, _CamacProperties
    );
}

int TCommonplaceCamacModule::NumberOfChannels(void) throw(THardwareException)
{
    return _CamacProperties.NumberOfChannels;
}

int TCommonplaceCamacModule::NextNumberOfDataElements(int Address) throw(THardwareException)
{
    return _CamacProperties.NumberOfSamples;
}



TCamacQADC_Rinei_RPC022::TCamacQADC_Rinei_RPC022(void)
: TCommonplaceCamacModule("CamacQADC", "Rinei_RPC022")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}



TCamacQADC_Hoshin_C009::TCamacQADC_Hoshin_C009(void)
: TCommonplaceCamacModule("CamacQADC", "Hoshin_C009")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}



TCamacTDC_Rinei_RPC060::TCamacTDC_Rinei_RPC060(void)
: TCommonplaceCamacModule("CamacTDC", "Rinei_RPC060")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}



TCamacTDC_Rinei_RPC130::TCamacTDC_Rinei_RPC130(void)
: TCommonplaceCamacModule("CamacTDC", "Rinei_RPC130")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}



TCamacTDC_Rinei_RPC140::TCamacTDC_Rinei_RPC140(void)
: TCommonplaceCamacModule("CamacTDC", "Rinei_RPC140")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}



TCamacTDC_Hoshin_C006::TCamacTDC_Hoshin_C006(void)
: TCommonplaceCamacModule("CamacTDC", "Hoshin_C006")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}



TCamacFADC_Rinei_RPC081::TCamacFADC_Rinei_RPC081(void)
: TCommonplaceCamacModule("CamacFADC", "Rinei_RPC081")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
}

TRoomCamacModule* TCamacFADC_Rinei_RPC081::Clone(void)
{
    return new TCamacFADC_Rinei_RPC081();
}

int TCamacFADC_Rinei_RPC081::Clear(int Address) throw(THardwareException)
{
    if (Address < 0) {
	for (Address = 0; Address < _NumberOfChannels; Address++) {
	    Transact(fnClear, Address);
	}
    }
    else {
	Transact(fnClear, Address);
    }

    int Data, Q, X;
    static const int fnStart = 26;
    Transact(fnStart, Address = 0, Data, Q, X);

    return 0;
}



TCamacFADC_Rinei_RPC250::TCamacFADC_Rinei_RPC250(void)
: TCommonplaceCamacModule("CamacFADC", "Rinei_RPC250")
{
    _CamacProperties.NumberOfChannels = _NumberOfChannels;
    _CamacProperties.NumberOfSamples = _NumberOfSamples;
    _CurrentSampleIndex = 0;
}

TRoomCamacModule* TCamacFADC_Rinei_RPC250::Clone(void)
{
    return new TCamacFADC_Rinei_RPC250();
}

int TCamacFADC_Rinei_RPC250::Read(int Address, int& Data) throw(THardwareException)
{
    if (++_CurrentSampleIndex > _NumberOfSamples) {
	return 0;
    }

    int Q, X;
    Transact(fnRead, Address, Data, Q, X);

    return ((Q != 0) && (X != 0)) ? 1: 0;
}

int TCamacFADC_Rinei_RPC250::Clear(int Address) throw(THardwareException)
{
    _CurrentSampleIndex = 0;

    static const int fnStart = 25;

    int Data, Q, X;
    Transact(fnClear, Address, Data, Q, X);
    Transact(fnStart, Address, Data, Q, X);

    return 1;
}



TCamacOutputRegister_Kaizu_KC3471::TCamacOutputRegister_Kaizu_KC3471(void)
: TRoomCamacModule("CamacOutputRegister", "Kaizu_KC3471")
{
}

TCamacOutputRegister_Kaizu_KC3471::~TCamacOutputRegister_Kaizu_KC3471()
{
}

TRoomCamacModule* TCamacOutputRegister_Kaizu_KC3471::Clone(void)
{
    return new TCamacOutputRegister_Kaizu_KC3471();
}

int TCamacOutputRegister_Kaizu_KC3471::NumberOfChannels(void) throw(THardwareException)
{
    return 0;
}

int TCamacOutputRegister_Kaizu_KC3471::NextNumberOfDataElements(int Address) throw(THardwareException)
{
    return 0;
}

int TCamacOutputRegister_Kaizu_KC3471::Read(int Address, int& Data) throw(THardwareException)
{
    throw THardwareException(
	"TCamacOutputRegister_Kaizu_KC3471::Read()",
	"function not available"
    );
}

int TCamacOutputRegister_Kaizu_KC3471::OutputLevel(int Data) throw(THardwareException)
{
    return Transact(fnOutputLevel, adOutput, Data);
}

int TCamacOutputRegister_Kaizu_KC3471::OutputPulse(int Data) throw(THardwareException)
{
    return Transact(fnOutputPulse, adOutput, Data);
}

int TCamacOutputRegister_Kaizu_KC3471::MiscControlIdOf(const std::string& CommandName) throw (THardwareException)
{
    int ControlId = -1;

    if (CommandName == "outputLevel") {
	ControlId = ControlId_OutputLevel;
    }
    else if (CommandName == "outputPulse") {
	ControlId = ControlId_OutputPulse;
    }
    else {
	throw THardwareException(
	    _ModelName, "unknown command: " + CommandName
	);
    }

    return ControlId;
}

int TCamacOutputRegister_Kaizu_KC3471::MiscControl(int ControlId, int* ArgumentList, int NumberOfArguments) throw (THardwareException)
{
    int Result = 1;

    if (ControlId == ControlId_OutputLevel) {
	if (NumberOfArguments < 1) {
	    throw THardwareException(
		"TCamacOutputRegister_Kaizu_KC3471::OutputLevel(int Data)",
		"too few argument[s]"
	    );
	}
	int Data = ArgumentList[0];
	Transact(fnOutputLevel, adOutput, Data);
    }
    else if (ControlId == ControlId_OutputPulse) {
	if (NumberOfArguments < 1) {
	    throw THardwareException(
		"TCamacOutputRegister_Kaizu_KC3471::OutputPulse(int Data)",
		"too few argument[s]"
	    );
	}
	int Data = ArgumentList[0];
	Transact(fnOutputPulse, adOutput, Data);
    }
    else {
	Result = 0;
    }

    return Result;
}
