/* module-CamacModules.hh */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 29 December 2002. */


#ifndef __module_CamacModules_hh__
#define __module_CamacModules_hh__


#include <string>
#include "RoomModule.hh"
#include "RoomCamacAccess.hh"


/* Standard Camac module */
class TStandardCamacModule: public TRoomCamacModule {
  public:
    TStandardCamacModule(void);
    virtual ~TStandardCamacModule();
    virtual TRoomCamacModule* Clone(void);
};


class TCommonplaceCamacModule: public TRoomCamacModule {
  protected:
    struct TCamacProperties {
	int NumberOfChannels;
	int NumberOfSamples;
    };
  public:
    TCommonplaceCamacModule(const std::string& ModuleType, const std::string& ModelName, TCamacProperties& CamacProperties);
    virtual ~TCommonplaceCamacModule();
    virtual TRoomCamacModule* Clone(void);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int NextNumberOfDataElements(int Address) throw(THardwareException);
  protected:
    TCommonplaceCamacModule(const std::string& ModuleType, const std::string& ModelName);
    TCamacProperties _CamacProperties;
};


/* Charge ADC Model RPC-022 (Rinei) */
class TCamacQADC_Rinei_RPC022: public TCommonplaceCamacModule {
  public:
    TCamacQADC_Rinei_RPC022(void);
  private:
    enum TQADCProperties {
	_NumberOfChannels = 16, _NumberOfSamples = 1
    };
};

/* Charge ADC Model C009 (Hohshin) */
class TCamacQADC_Hoshin_C009: public TCommonplaceCamacModule {
  public:
    TCamacQADC_Hoshin_C009(void);
  private:
    enum TQADCProperties {
	_NumberOfChannels = 16, _NumberOfSamples = 1
    };
};

/* TDC Model RPC-060 (Rinei) */
class TCamacTDC_Rinei_RPC060: public TCommonplaceCamacModule {
  public:
    TCamacTDC_Rinei_RPC060(void);
  private:
    enum TTDCProperties {
	_NumberOfChannels = 8, _NumberOfSamples = 1
    };
};

/* TDC Model RPC-130 (Rinei) */
class TCamacTDC_Rinei_RPC130: public TCommonplaceCamacModule {
  public:
    TCamacTDC_Rinei_RPC130(void);
  private:
    enum TTDCProperties {
	_NumberOfChannels = 8, _NumberOfSamples = 1
    };
};

/* TDC Model RPC-140 (Rinei) */
class TCamacTDC_Rinei_RPC140: public TCommonplaceCamacModule {
  public:
    TCamacTDC_Rinei_RPC140(void);
  private:
    enum TTDCProperties {
	_NumberOfChannels = 16, _NumberOfSamples = 1
    };
};

/* TDC Model C006 (Hoshin) */
class TCamacTDC_Hoshin_C006: public TCommonplaceCamacModule {
  public:
    TCamacTDC_Hoshin_C006(void);
  private:
    enum TTDCProperties {
	_NumberOfChannels = 8, _NumberOfSamples = 1
    };
};

/* Flush ADC MODEL RPC-081 (Rinei) */
class TCamacFADC_Rinei_RPC081: public TCommonplaceCamacModule {
  public:
    TCamacFADC_Rinei_RPC081(void);
    virtual TRoomCamacModule* Clone(void);
    virtual int Clear(int Channel) throw(THardwareException);
  private:
    enum TFADCProperties {
	_NumberOfChannels = 4, _NumberOfSamples = 1024
    };
};

/* Flush ADC MODEL RPC-250 (Rinei) */
class TCamacFADC_Rinei_RPC250: public TCommonplaceCamacModule {
  public:
    TCamacFADC_Rinei_RPC250(void);
    virtual TRoomCamacModule* Clone(void);
    virtual int Read(int Address, int& Data) throw(THardwareException);
    virtual int Clear(int Channel) throw(THardwareException);
  private:
    enum TFADCProperties {
	_NumberOfChannels = 2, _NumberOfSamples = 8192
    };
  private:
    int _CurrentSampleIndex;
};

/* Output Register Model KC3471 (Kaizu) */
class TCamacOutputRegister_Kaizu_KC3471: public TRoomCamacModule {
  public:
    TCamacOutputRegister_Kaizu_KC3471(void);
    virtual ~TCamacOutputRegister_Kaizu_KC3471();
    virtual TRoomCamacModule* Clone(void);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int NextNumberOfDataElements(int Address) throw(THardwareException);
    virtual int Read(int Address, int& Data) throw(THardwareException);
  public:
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    int OutputLevel(int Data) throw(THardwareException);
    int OutputPulse(int Data) throw(THardwareException);
  public:
    enum TControlId {
	ControlId_OutputLevel,
	ControlId_OutputPulse,
	_NumberOfControls
    };
  private:
    enum TCamacFunctionTable {
	fnOutputLevel = 16,
	fnOutputPulse = 17
    };
    enum TCamacAddressTable {
	adOutput = 0
    };
};


#endif
