/* module-Hoshin_V004.cc */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 26 December 2001. */


#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "module-Hoshin_V004.hh"

using namespace std;


static TRoomVmeModuleCreator Creator3(
    "Hoshin_V004", new TVmeScaler_Hoshin_V004()
);


TVmeScaler_Hoshin_V004::TVmeScaler_Hoshin_V004(void)
: TRoomVmeModule("VmeScaler", "Hoshin_V004", (TRoomVmeTransferMode) V004_TransferMode, (size_t) V004_MemorySize)
{
    _DataArea = 0;
}

TVmeScaler_Hoshin_V004::~TVmeScaler_Hoshin_V004()
{
}

TRoomVmeModule* TVmeScaler_Hoshin_V004::Clone(void)
{
    return new TVmeScaler_Hoshin_V004();
}

int TVmeScaler_Hoshin_V004::Initialize(int InitialState) throw(THardwareException)
{
    _DataArea = DoubleWordPointer();
    Disable();
    Clear();

    return 0;
}

int TVmeScaler_Hoshin_V004::Read(int Address, int &Data) throw(THardwareException)
{
    Data = _DataArea[Address] & maskData;

    return 1;
}

int TVmeScaler_Hoshin_V004::Enable(int Address) throw(THardwareException)
{
    if (Address < 0) {
	for (Address = 0; Address < _NumberOfChannels; Address++) {
	    _DataArea[Address] = bitStart; 
	}
    }
    else {
	_DataArea[Address] = bitStart; 
    }

    return 0;
}

int TVmeScaler_Hoshin_V004::Disable(int Address) throw(THardwareException)
{
    if (Address < 0) {
	for (Address = 0; Address < _NumberOfChannels; Address++) {
	    _DataArea[Address] = bitStop; 
	}
    }
    else {
	_DataArea[Address] = bitStop; 
    }
    
    return 0;
}

int TVmeScaler_Hoshin_V004::Clear(int Address) throw(THardwareException)
{
    if (Address < 0) {
	for (Address = 0; Address < _NumberOfChannels; Address++) {
	    _DataArea[Address] = bitReset; 
	}
    }
    else {
	_DataArea[Address] = bitReset; 
    }
    
    return 0;
}

int TVmeScaler_Hoshin_V004::NumberOfChannels(void) throw(THardwareException)
{
    return _NumberOfChannels;
}
