/* module-Hoshin_V004.hh */
/* Created by Enomoto Sanshiro on 26 May 1997. */
/* Last updated by Enomoto Sanshiro on 26 December 2001. */


#ifndef __module_Hoshin_V004_hh__
#define __module_Hoshin_V004_hh__


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


/* VME 150MHz 8ch Scaler Model V004 (Hoshin) */
class TVmeScaler_Hoshin_V004: public TRoomVmeModule {
  public:
    TVmeScaler_Hoshin_V004(void);
    virtual ~TVmeScaler_Hoshin_V004();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Read(int Address, int& Data) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address= -1) throw(THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
  protected:
    volatile DoubleWord* _DataArea;
  private:
    enum TV004Parameters {
	V004_MemorySize = 0x1000,
	V004_TransferMode = VmeTransferMode_A24D32
    };
    enum TV004Symbols {
	bitStart = 0x00000100,
	bitStop  = 0x00000200,
	bitReset = 0x00000400,
	maskData = 0x1fffffff,
	_NumberOfChannels = 8
    };
};


#endif
