/* module-LeCroy_2277.hh */
/* Created by Enomoto Sanshiro on 19 April 2002. */
/* Last updated by Enomoto Sanshiro on 19 April 2002. */


// **************************************** //
// * THIS CODE IS NOT TESTED. DO NOT USE. * //
// **************************************** //


#ifndef __module_LeCroy_2277_hh__
#define __module_LeCroy_2277_hh__


#include <string>
#include "RoomModule.hh"
#include "RoomCamacAccess.hh"


/* CAMAC Multi-hit TDC Model 2277 (LeCroy) */
class TCamacTDC_LeCroy_2277: public TRoomCamacModule {
  public:
    TCamacTDC_LeCroy_2277(void);
    virtual ~TCamacTDC_LeCroy_2277();
    virtual TRoomCamacModule* Clone(void);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int SequentialRead(int Address, int Data[], int MaxSize) throw(THardwareException);
    virtual int NextNumberOfDataElements(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
  protected:
    int ReadDataBlockTo(void* Data, int MaxSize) throw(THardwareException);
    inline int DataOf(U32bit Data);
    inline int AddressOf(U32bit Data);
    inline int EdgePolarityOf(U32bit Data);
  protected:
    U32bit* _Buffer;
    int _BufferSize;
    int _NumberOfData;
  public:
    enum {
	_NumberOfChannels = 32,
	_NumberOfSamples = 16
    };
};


inline int TCamacTDC_LeCroy_2277::DataOf(U32bit Data)
{
    return (Data >> 0) & 0x0000ffff;
}

inline int TCamacTDC_LeCroy_2277::EdgePolarityOf(U32bit Data)
{
    return (Data >> 16) & 0x00000001;
}

inline int TCamacTDC_LeCroy_2277::AddressOf(U32bit Data)
{
    return (Data >> 17) & 0x0000001f;
}


#endif
