/* module-Rinei_RPC360.cc */
/* Created by Enomoto Sanshiro on 19 February 2002. */
/* Last updated by Enomoto Sanshiro on 19 February 2002. */


#include <string>
#include "RoomDeviceFactory.hh"
#include "RoomModule.hh"
#include "RoomCamacAccess.hh"
#include "module-Rinei_RPC360.hh"


static TRoomCamacModuleCreator Creator(
    "Rinei_RPC360", new TCamacMisc_Rinei_RPC360()
);



TCamacMisc_Rinei_RPC360::TCamacMisc_Rinei_RPC360(void)
: TRoomCamacModule("CamacMisc", "Rinei_RPC360")
{
}

TCamacMisc_Rinei_RPC360::~TCamacMisc_Rinei_RPC360()
{
}

TRoomCamacModule* TCamacMisc_Rinei_RPC360::Clone(void)
{
    return new TCamacMisc_Rinei_RPC360();
}

int TCamacMisc_Rinei_RPC360::EnableLam(void) throw(THardwareException)
{
    return 1;
}

int TCamacMisc_Rinei_RPC360::DisableLam(void) throw(THardwareException)
{
    return 1;
}

int TCamacMisc_Rinei_RPC360::ClearLam(void) throw(THardwareException)
{
    return 1;
}

int TCamacMisc_Rinei_RPC360::MiscControlIdOf(const std::string& CommandName) throw (THardwareException)
{
    int ControlId = -1;

    if (CommandName == "clearCounter") {
	ControlId = ControlId_ClearCounter;
    }
    else if (CommandName == "startCounter") {
	ControlId = ControlId_StartCounter;
    }
    else if (CommandName == "stopCounter") {
	ControlId = ControlId_StopCounter;
    }
    else {
	throw THardwareException(
	    "TCamacMisc_Rinei_RPC360::MiscControlIdOf()",
	    "unknown command: " + CommandName
	);
    }

    return ControlId;
}

int TCamacMisc_Rinei_RPC360::MiscControl(int ControlId, int* ArgumentList, int NumberOfArguments) throw (THardwareException)
{
    int Address, Function;

    if (ControlId == ControlId_ClearCounter) {
	return Transact(Function = 9, Address = 1);
    }
    else if (ControlId == ControlId_StartCounter) {
	return Transact(Function = 26, Address = 1);
    }
    else if (ControlId == ControlId_StopCounter) {
	return Transact(Function = 24, Address = 1);
    }
    else {
	return 0;
    }
}
