/* module-Rinei_RPV160.hh */
/* Created by Enomoto Sanshiro on 1 October 2002. */
/* Last updated by Enomoto Sanshiro on 24 November 2002. */


#ifndef __module_Rinei_RPV160_hh__
#define __module_Rinei_RPV160_hh__


#include "RoomVmeAccess.hh"


class TVmeFADC_Rinei_RPV160: public TRoomVmeModule {
  public:
    TVmeFADC_Rinei_RPV160(void);
    virtual ~TVmeFADC_Rinei_RPV160();
    virtual TRoomVmeModule* Clone(void);
  public:
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Finalize(int FinalState = 0) throw(THardwareException);
    virtual int Enable(int Address = -1) throw(THardwareException);
    virtual int Disable(int Address = -1) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual bool HasData(int Address = -1) throw(THardwareException);
    virtual bool WaitData(unsigned TimeOut_sec = 1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int NextNumberOfDataElements(int Address = -1) throw(THardwareException);
    virtual int SequentialRead(int Address, int Data[], int MaxSize) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    virtual int NumberOfChannels(void) throw(THardwareException);
    virtual int AddressBitLength(void);
    virtual int DataBitLength(void);
  public:
    virtual bool IsSignalOnServiceRequestAvailable(void);
    virtual void ClearServiceRequest(void) throw(THardwareException);
  public:
    enum TRPV160_ContolId {
	ControlId_Start,
	ControlId_Stop,
	_NumberOfControls
    };
    enum TRPV160_Parameters {
	RPV160_TransferMode = VmeTransferMode_A32D16,
	RPV160_MapSize = 0x1000,
	RPV160_MapOffset = 0x30000,
	RPV160_NumberOfChannels = 8,
	RPV160_NumberOfSamples = 0x2000,
	RPV160_DataBlockSize = 0x2000,
	RPV160_NumberOfDataWords = 0x1000,
	RPV160_AddressBitLength = 8,
	RPV160_DataBitLength = 8,
	RPV160_DataWordSize = 2,
	_NumberOfParameters
    };
    enum TRPV160_RegisterOffset {
	regAddressCounter = 0x0000,
	regStatus = 0x0004,
	regControl = 0x0008,
	_NumberOfRegisters
    };
    enum TRPV160_RegisterBit {
        bitStart = 0x0001,
        bitStop = 0x0002,
        bitClear = 0x0004,
        bitDone = 0x0020,
	_NumberOfRegisterBits
    };
  protected:
    TRoomVmeAccessProperty* _AccessProperty;
    U32bit _EnabledChannelBits;
    int _NumberOfEnabledChannels;
  private:
    int _StartWordIndex;
    int _ReadoutCount[RPV160_NumberOfChannels];
    U16bit* _Buffer[RPV160_NumberOfChannels];
};


#endif
