/* module-SIS_3600.hh */
/* Created by Glenn H-S. on 31 Aug 2000. */
/* Last updated by Enomoto Sanshiro on 9 August 2002. */


#ifndef __SIS_3600_hh__
#define __SIS_3600_hh__


#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"


class TVmeLatch_SIS_3600: public TRoomVmeModule {
  public:
    TVmeLatch_SIS_3600(void);
    virtual ~TVmeLatch_SIS_3600();
    virtual TRoomVmeModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int Clear(int Address = -1) throw(THardwareException);
    virtual int Read(int Address, int &Data) throw(THardwareException);
    virtual int BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException);
    virtual int NextDataBlockSize(int Address = -1) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
  private:
    volatile DoubleWord _DummyVariableToAvoidCompilerOptimization;
  private:
    enum internal_parameters_e {
        SIS3600_TransferMode = VmeTransferMode_A32D32,
	SIS3600_MapSize = 0x1000
    };
    enum constant_e { 
        FifoSize = 4 * 32 * 1024,
	FifoWindowSize = 256
    };
    enum registers_e {
	regCSR = 0x000,
	regIdIrq = 0x004,
	regFastClearWindow = 0x008,
	regPulserFrequency = 0x00C,
	regClearFifo = 0x020,
	regVmeNext = 0x024,
	regEnableNextClock = 0x028,
	regDisableNextClock = 0x02c,
	regFastClearEnable = 0x050,
	regFastClearDisable = 0x054,
	regReset = 0x060,
	regSoftOnePulseOut = 0x068,
	regFifoRead = 0x100,
	regFifoStart = 0x100,
	_NumberOfRegisters
    };
    enum bitmasks_e {
	bitUserLED         = 1<<0,
	bitFifoTest        = 1<<1,
	bitOutModeB0       = 1<<2,
	bitOutModeB1       = 1<<3,
	bitPulseOutEna     = 1<<4,
	bitPipeMode        = 1<<5,
	bitFifoEmpty       = 1<<8,
	bitFifoAlmostEmpty = 1<<9,
	bitFifoHalfFull    = 1<<10,
	bitFifoAlmostFull  = 1<<11,
	bitFifoFull        = 1<<12,
	bitFastClrEna      = 1<<14,
	bitNextEna         = 1<<15,
	bitExtNextEna      = 1<<16,
	bitExtClearEna     = 1<<17,
	bitLatchGate       = 1<<18,
	bitCoincidenceMode = 1<<19
    };
};


#endif
