/* module-SIS_3601.cc */
/* Created by D. Murphree on 30 Oct 2000. */
/* Last updated by Enomoto Sanshiro on 29 December 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomVmeAccess.hh"
#include "module-SIS_3601.hh"

using namespace std;


static TRoomVmeModuleCreator Creator("SIS_3601", new TVmeOutputRegister_SIS_3601());


TVmeOutputRegister_SIS_3601::TVmeOutputRegister_SIS_3601()
: TRoomVmeModule("VmeOutputRegister", "SIS_3601", (TRoomVmeTransferMode) SIS3601_TransferMode, (size_t) SIS3601_MapSize)
{
}

TVmeOutputRegister_SIS_3601::~TVmeOutputRegister_SIS_3601()
{
}

TRoomVmeModule* TVmeOutputRegister_SIS_3601::Clone(void)
{
    return new TVmeOutputRegister_SIS_3601();
}

int TVmeOutputRegister_SIS_3601::Initialize(int InitialState) throw(THardwareException)
{
    PutDoubleWord(regReset, 0);
    return 1;
}

int TVmeOutputRegister_SIS_3601::WriteRegister(int Address, int Data) throw(THardwareException)
{
    PutDoubleWord(Address, Data);
    return 1;
}

int TVmeOutputRegister_SIS_3601::ReadRegister(int Address, int& Data) throw(THardwareException)
{
    Data = GetDoubleWord(Address);
    return 1;
}

void TVmeOutputRegister_SIS_3601::Output(int Data)
{
    PutDoubleWord(regOutput, Data);
}

void TVmeOutputRegister_SIS_3601::EnableLevelMode(void)
{
    PutDoubleWord(regCSR, bitEnableLevelMode);
}

void TVmeOutputRegister_SIS_3601::EnablePulseMode(void)
{
    PutDoubleWord(regCSR, bitEnablePulseMode);
}

void TVmeOutputRegister_SIS_3601::EnableOutputInversion(void)
{
    PutDoubleWord(regCSR, bitEnableOutputInversion);
}

void TVmeOutputRegister_SIS_3601::DisableOutputInversion(void)
{
    PutDoubleWord(regCSR, bitDisableOutputInversion);
}

int TVmeOutputRegister_SIS_3601::MiscControlIdOf(const std::string& CommandName) throw (THardwareException)
{
    int ControlId = -1;

    if (CommandName == "output") {
	ControlId = ControlId_Output;
    }
    else if (CommandName == "enableLevelMode") {
	ControlId = ControlId_EnableLevelMode;
    }
    else if (CommandName == "enablePulseMode") {
	ControlId = ControlId_EnablePulseMode;
    }
    else if (CommandName == "enableOutputInversion") {
	ControlId = ControlId_EnableOutputInversion;
    }
    else if (CommandName == "disableOutputInversion") {
	ControlId = ControlId_DisableOutputInversion;
    }
    else {
	throw THardwareException(
	    _ModelName, "unknown command: " + CommandName
	);
    }

    return ControlId;
}

int TVmeOutputRegister_SIS_3601::MiscControl(int ControlId, int* ArgumentList, int NumberOfArguments) throw (THardwareException)
{
    int Result = 1;

    if (ControlId == ControlId_Output) {
	if (NumberOfArguments < 1) {
	    throw THardwareException(
		"TVmeOutputRegister_SIS_3601::Output(int Value)",
		"too few argument[s]"
	    );
	}
	PutDoubleWord(regOutput, ArgumentList[0]);
    }
    else if (ControlId == ControlId_EnablePulseMode) {
	PutDoubleWord(regCSR, bitEnablePulseMode);
    }
    else if (ControlId == ControlId_EnableLevelMode) {
	PutDoubleWord(regCSR, bitEnableLevelMode);
    }
    else if (ControlId == ControlId_EnableOutputInversion) {
	PutDoubleWord(regCSR, bitEnableOutputInversion);
    }
    else if (ControlId == ControlId_DisableOutputInversion) {
	PutDoubleWord(regCSR, bitDisableOutputInversion);
    }
    else {
	Result = 0;
    }

    return Result;
}
