/* module-SIS_3601.hh */
/* Created by D. Murphree on 30 Oct 2000. */
/* Last updated by Enomoto Sanshiro on 29 December 2002. */


#ifndef __SIS_3601_hh__
#define __SIS_3601_hh__


#include "RoomDefs.hh"
#include "RoomModule.hh"
#include "RoomVmeAccess.hh"

  
class TVmeOutputRegister_SIS_3601: public TRoomVmeModule {
  public:
    TVmeOutputRegister_SIS_3601();
    virtual ~TVmeOutputRegister_SIS_3601();
    virtual TRoomVmeModule* Clone(void);
    virtual int Initialize(int InitialState = 0) throw(THardwareException);
    virtual int WriteRegister(int Address, int Data) throw(THardwareException);
    virtual int ReadRegister(int Address, int& Data) throw(THardwareException);
  public:
    virtual int MiscControlIdOf(const std::string& CommandName) throw (THardwareException);
    virtual int MiscControl(int ControlId, int* ArgumentList = 0, int NumberOfArguments = 0) throw (THardwareException);
    void Output(int Data);
    void EnableLevelMode(void);
    void EnablePulseMode(void);
    void EnableOutputInversion(void);
    void DisableOutputInversion(void);
  public:
    enum TControlId {
	ControlId_Output,
	ControlId_EnableLevelMode,
	ControlId_EnablePulseMode,
	ControlId_EnableOutputInversion,
	ControlId_DisableOutputInversion,
	_NumberOfControls
    };
  private:
    enum TSIS3601Parameters {
        SIS3601_TransferMode = VmeTransferMode_A32D32,
	SIS3601_MapSize = 0x1000
    };
    enum TSIS3601Registers {
	regCSR = 0x0000,
	regOutput = 0x0008,
	regNextClock = 0x0024,      
	regReset = 0x0060
    };
    enum TSIS3601CSRBits {
	bitSwitchOnUserOutput = 0x0001 << 0,
	bitEnableAutoIncrementMode = 0x0001 << 1,
	bitEnableOutputInversion = 0x0001 << 2,
	bitEnablePulseMode = 0x0001 << 3,
	bitSwitchOffUserOutput = 0x0001 << 8,
	bitDisableAutoIncrementMode = 0x0001 << 9,
	bitDisableOutputInversion = 0x0001 << 10,
	bitEnableLevelMode = 0x0001 << 11
    };
};


#endif
