/* module-SIS_3801.cc */
/* Created by Glenn H-S. on 31 Aug 2000. */
/* Last updated by Enomoto Sanshiro on 9 August 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomVmeAccess.hh"
#include "module-SIS_3801.hh"

using namespace std;


static TRoomVmeModuleCreator Creator("SIS_3801", new TVmeScaler_SIS_3801());


TVmeScaler_SIS_3801::TVmeScaler_SIS_3801()
: TRoomVmeModule("VmeScaler", "SIS_3801", (TRoomVmeTransferMode) SIS3801_TransferMode, (size_t) SIS3801_MapSize)
{
}

TVmeScaler_SIS_3801::~TVmeScaler_SIS_3801()
{
}

TRoomVmeModule* TVmeScaler_SIS_3801::Clone(void)
{
    return new TVmeScaler_SIS_3801();
}

int TVmeScaler_SIS_3801::Initialize(int InitialState) throw(THardwareException)
{
    PutDoubleWord(regReset, 0);
    Clear();

    return 1;
}

int TVmeScaler_SIS_3801::Clear(int Channel) throw(THardwareException)
{
    // keep the following order //
    PutDoubleWord(regDisableNextClock, 0);
    PutDoubleWord(regClearFifo, 0);
    PutDoubleWord(regEnableNextClock, 0);
    PutDoubleWord(regCSR, bitExtNextEna);

    // EnableNextClock generates one word of garbage data
    _DummyVariableToAvoidCompilerOptimization = GetDoubleWord(regFifoRead);  
	
    return 0;
}

int TVmeScaler_SIS_3801::Read(int Address, int &Data) throw(THardwareException)
{
    if ((GetDoubleWord(regCSR) & bitFifoEmpty) == 0) {
	Data = GetDoubleWord(regFifoRead);
	return 1;
    }
    else {
	Data = -1;
	return 0;
    }
}

int TVmeScaler_SIS_3801::NextDataBlockSize(int Address) throw(THardwareException)
{ 
    return FifoSize; 
}

int TVmeScaler_SIS_3801::BlockRead(int Address, void *Data, int MaxSize) throw(THardwareException)
{
    DoubleWord *Next = (DoubleWord*) Data;
    DoubleWord *End= Next + MaxSize / sizeof(DoubleWord);

    bool IsFifoFull = GetDoubleWord(regCSR) & bitFifoFull;
    
    while ((GetDoubleWord(regCSR) & bitFifoEmpty) == 0 && Next < End) {
	*(Next++) = GetDoubleWord(regFifoRead);
    }
    
    if (IsFifoFull) {
        cerr << "SIS-3801 FIFO FULL" << endl;
	PutDoubleWord(regClearFifo, 0);   // reset required to continue
    }
    
    return (Next - (DoubleWord*) Data) * sizeof(DoubleWord);
}

int TVmeScaler_SIS_3801::ReadRegister(int Address, int& Data) throw(THardwareException)
{
    Data = GetDoubleWord(Address);
    return 1;
}

int TVmeScaler_SIS_3801::WriteRegister(int Address, int Data) throw(THardwareException)
{
    PutDoubleWord(Address, Data);
    return 1;
}
